/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.mixin.create.client;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerRenderer;
import com.simibubi.create.content.processing.burner.BlazeBurnerVisual;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import plus.dragons.createcentralkitchen.client.burner.BlazeBurnerClientExtension;
import plus.dragons.createcentralkitchen.client.burner.BlazeBurnerRenderOverride;

@Mixin(value={BlazeBurnerVisual.class})
public abstract class BlazeBurnerVisualMixin
extends AbstractBlockEntityVisual<BlazeBurnerBlockEntity> {
    @Shadow
    private BlazeBurnerBlock.HeatLevel heatLevel;
    @Shadow
    private boolean validBlockAbove;
    @Shadow
    @Final
    private TransformedInstance head;
    @Shadow
    @Nullable
    private TransformedInstance smallRods;
    @Shadow
    @Nullable
    private TransformedInstance largeRods;
    @Shadow
    @Nullable
    private ScrollInstance flame;
    @Shadow
    @Nullable
    private TransformedInstance hat;
    @Unique
    @Nullable
    private PartialModel hatModelOverride;
    @Unique
    @Nullable
    private BlazeBurnerRenderOverride renderOverride;

    private BlazeBurnerVisualMixin(VisualizationContext ctx, BlazeBurnerBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
    }

    @ModifyVariable(method={"animate"}, at=@At(value="STORE", ordinal=0), index=5)
    private boolean updateChefHat(boolean hatPresent) {
        PartialModel hatModelOverride;
        BlazeBurnerRenderOverride renderOverride = ((BlazeBurnerClientExtension)this.blockEntity).getRenderOverride();
        PartialModel partialModel = renderOverride == null ? null : (hatModelOverride = renderOverride.getHatModel(this.heatLevel == BlazeBurnerBlock.HeatLevel.SMOULDERING));
        if (hatPresent || hatModelOverride == null) {
            if (this.hatModelOverride != null && this.hat != null) {
                this.hat.delete();
                this.hat = null;
            }
            this.hatModelOverride = null;
        } else if (this.hatModelOverride != hatModelOverride) {
            Instancer instancer = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)hatModelOverride));
            if (this.hat != null) {
                instancer.stealInstance((Instance)this.hat);
            } else {
                this.hat = (TransformedInstance)instancer.createInstance();
            }
            this.hatModelOverride = hatModelOverride;
        }
        return hatPresent || hatModelOverride != null;
    }

    @Inject(method={"animate"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/processing/burner/BlazeBurnerRenderer;getBlazeModel(Lcom/simibubi/create/content/processing/burner/BlazeBurnerBlock$HeatLevel;Z)Ldev/engine_room/flywheel/lib/model/baked/PartialModel;"), @At(value="INVOKE", target="Lcom/simibubi/create/content/processing/burner/BlazeBurnerVisual;setupFlameInstance()V")})
    private void animate$resetOverride(float partialTicks, CallbackInfo ci) {
        this.renderOverride = null;
    }

    @Inject(method={"animate"}, at={@At(value="INVOKE", target="Ljava/lang/Object;hashCode()I")})
    private void animate$setupOverride(float partialTicks, CallbackInfo ci) {
        BlazeBurnerRenderOverride renderOverride = ((BlazeBurnerClientExtension)this.blockEntity).getRenderOverride();
        if (this.renderOverride != renderOverride) {
            boolean superHeated;
            PartialModel headModel = renderOverride != null ? renderOverride.getBlazeModel(this.heatLevel, this.validBlockAbove) : BlazeBurnerRenderer.getBlazeModel((BlazeBurnerBlock.HeatLevel)this.heatLevel, (boolean)this.validBlockAbove);
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)headModel)).stealInstance((Instance)this.head);
            boolean bl = superHeated = this.heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING;
            if (this.smallRods != null) {
                PartialModel smallRodsModel = renderOverride != null ? renderOverride.getSmallRodsModel(superHeated) : (superHeated ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS);
                this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)smallRodsModel)).stealInstance((Instance)this.smallRods);
            }
            if (this.largeRods != null) {
                PartialModel largeRodsModel = renderOverride != null ? renderOverride.getLargeRodsModel(superHeated) : (superHeated ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2);
                this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)largeRodsModel)).stealInstance((Instance)this.largeRods);
            }
            if (this.flame != null) {
                SpriteShiftEntry spriteShift = renderOverride != null ? renderOverride.getFlameSpriteShift(superHeated) : (superHeated ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME);
                float spriteWidth = spriteShift.getTarget().getU1() - spriteShift.getTarget().getU0();
                float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
                float speed = 0.03125f + 0.015625f * (float)this.heatLevel.ordinal();
                this.flame.speedU = speed / 2.0f;
                this.flame.speedV = speed;
                this.flame.scaleU = spriteWidth / 2.0f;
                this.flame.scaleV = spriteHeight / 2.0f;
                this.flame.diffU = spriteShift.getTarget().getU0() - spriteShift.getOriginal().getU0();
                this.flame.diffV = spriteShift.getTarget().getV0() - spriteShift.getOriginal().getV0();
            }
            this.renderOverride = renderOverride;
        }
    }
}

