/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.kinetics.fan.freezing;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.processing.freeze.BlockFreezer;
import plus.dragons.createdragonsplus.common.processing.freeze.FreezeCondition;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;
import plus.dragons.createdragonsplus.config.CDPConfig;
import plus.dragons.createdragonsplus.integration.ModIntegration;

public class FreezingFanProcessingType
implements FanProcessingType {
    private final DeferredHolder<FanProcessingType, FanProcessingType> createGarnishedType = ModIntegration.CREATE_GARNISHED.fanType("freezing");
    private final DeferredHolder<RecipeType<?>, RecipeType<StandardProcessingRecipe<SingleRecipeInput>>> createGarnishedRecipe = ModIntegration.CREATE_GARNISHED.recipeType("freezing");
    private final DeferredHolder<FanProcessingType, FanProcessingType> createDNDType = ModIntegration.CREATE_DND.fanType("freezing");
    private final DeferredHolder<RecipeType<?>, RecipeType<StandardProcessingRecipe<SingleRecipeInput>>> createDNDRecipe = ModIntegration.CREATE_DND.recipeType("freezing");

    public boolean isValidAt(Level level, BlockPos pos) {
        if (!((Boolean)CDPConfig.recipes().enableBulkFreezing.get()).booleanValue()) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        float freeze = BlockFreezer.findFreeze(level, pos, state);
        if (freeze >= 0.0f) {
            return true;
        }
        return this.createGarnishedType.isBound() && ((FanProcessingType)this.createGarnishedType.get()).isValidAt(level, pos) || this.createDNDType.isBound() && ((FanProcessingType)this.createDNDType.get()).isValidAt(level, pos);
    }

    public int getPriority() {
        return 600;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        if (!((Boolean)CDPConfig.recipes().enableBulkFreezing.get()).booleanValue()) {
            return false;
        }
        Optional recipe = level.getRecipeManager().getRecipeFor(CDPRecipes.FREEZING.getType(), (RecipeInput)new SingleRecipeInput(stack), level);
        if (recipe.isPresent()) {
            return true;
        }
        return this.canProcessByCompatRecipe(this.createGarnishedRecipe, stack, level) || this.canProcessByCompatRecipe(this.createDNDRecipe, stack, level);
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        return level.getRecipeManager().getRecipeFor(CDPRecipes.FREEZING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipe.value(), (boolean)true)).or(() -> {
            Optional<List<ItemStack>> result = this.processByCompatRecipe(this.createGarnishedRecipe, stack, level);
            if (result.isEmpty()) {
                result = this.processByCompatRecipe(this.createDNDRecipe, stack, level);
            }
            return result;
        }).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        int color = Color.mixColors((int)FreezeCondition.PASSIVE.getColor(), (int)FreezeCondition.FROZEN.getColor(), (float)random.nextFloat());
        particleAccess.setColor(color);
        particleAccess.setAlpha(1.0f);
        if (random.nextInt(32) == 0) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.125f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        if (entity.canFreeze()) {
            entity.setTicksFrozen(Math.min(entity.getTicksRequiredToFreeze(), entity.getTicksFrozen()) + 3);
        }
        entity.extinguishFire();
    }

    private boolean canProcessByCompatRecipe(DeferredHolder<RecipeType<?>, RecipeType<StandardProcessingRecipe<SingleRecipeInput>>> recipeType, ItemStack stack, Level level) {
        if (!recipeType.isBound()) {
            return false;
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)recipeType.get(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
    }

    private Optional<List<ItemStack>> processByCompatRecipe(DeferredHolder<RecipeType<?>, RecipeType<StandardProcessingRecipe<SingleRecipeInput>>> recipeType, ItemStack stack, Level level) {
        if (!recipeType.isBound()) {
            return Optional.empty();
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)recipeType.get(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipe.value(), (boolean)true));
    }
}

