/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.kinetics.grindstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;
import plus.dragons.createenchantmentindustry.integration.jei.category.assembly.AssemblyGrindingCategory;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class GrindingRecipe
extends StandardProcessingRecipe<SingleRecipeInput>
implements IAssemblyRecipe {
    public GrindingRecipe(ProcessingRecipeParams params) {
        super(CEIRecipes.GRINDING, params);
        if (this.fluidIngredients.size() + this.fluidResults.size() > 1) {
            throw new IllegalArgumentException("Grinding recipe can only have either 1 fluid input or 1 fluid result");
        }
    }

    public static StandardProcessingRecipe.Builder<GrindingRecipe> builder(ResourceLocation id) {
        return new StandardProcessingRecipe.Builder(GrindingRecipe::new, id);
    }

    public static Optional<RecipeHolder<GrindingRecipe>> fromPolishing(RecipeHolder<SandPaperPolishingRecipe> recipe) {
        if (AllRecipeTypes.CAN_BE_AUTOMATED.test(recipe)) {
            ResourceLocation id = recipe.id().withSuffix("_using_grindstone");
            SandPaperPolishingRecipe polishing = (SandPaperPolishingRecipe)recipe.value();
            GrindingRecipe grinding = (GrindingRecipe)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)GrindingRecipe.builder(id).require((Ingredient)polishing.getIngredients().getFirst())).output((ProcessingOutput)polishing.getRollableResults().getFirst())).build();
            return Optional.of(new RecipeHolder(id, (Recipe)grinding));
        }
        return Optional.empty();
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidOutputCount() {
        return 1;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return ((Ingredient)this.ingredients.getFirst()).test(input.item());
    }

    public Component getDescriptionForAssembly() {
        if (this.fluidIngredients.isEmpty()) {
            return CEILang.translate("recipe.assembly.grinding", new Object[0]).component();
        }
        List<FluidStack> matchingFluidStacks = Arrays.asList(((SizedFluidIngredient)this.fluidIngredients.getFirst()).getFluids());
        if (matchingFluidStacks.isEmpty()) {
            return Component.literal((String)"Invalid");
        }
        return CEILang.translate("recipe.assembly.grinding.needs_fluid", matchingFluidStacks.getFirst().getHoverName()).component();
    }

    public void addRequiredMachines(Set<ItemLike> required) {
        required.add((ItemLike)CEIBlocks.MECHANICAL_GRINDSTONE);
        required.add((ItemLike)AllBlocks.ITEM_DRAIN);
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyGrindingCategory::new;
    }
}

