/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.registry;

import com.adonis.createshimmer.common.CSCommon;
import com.adonis.createshimmer.util.CSIntIntPair;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateDataMapProvider;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import plus.dragons.createdragonsplus.common.registry.CDPFluids;
import plus.dragons.createdragonsplus.util.Pairs;

public class CSDataMaps {
    public static final DataMapType<Fluid, Integer> FLUID_UNIT_EXPERIENCE = DataMapType.builder((ResourceLocation)CSCommon.asResource("unit/experience"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_ADDRESS_INGREDIENT = DataMapType.builder((ResourceLocation)CSCommon.asResource("printing/address/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_PATTERN_INGREDIENT = DataMapType.builder((ResourceLocation)CSCommon.asResource("printing/pattern/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_COPY_INGREDIENT = DataMapType.builder((ResourceLocation)CSCommon.asResource("printing/copy/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_CUSTOM_NAME_INGREDIENT = DataMapType.builder((ResourceLocation)CSCommon.asResource("printing/custom_name/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Style> PRINTING_CUSTOM_NAME_STYLE = DataMapType.builder((ResourceLocation)CSCommon.asResource("printing/custom_name/style"), (ResourceKey)Registries.FLUID, (Codec)Style.Serializer.CODEC).synced(Style.Serializer.CODEC, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_WRITTEN_BOOK_INGREDIENT = DataMapType.builder((ResourceLocation)CSCommon.asResource("printing/written_book/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Enchantment, List<CSIntIntPair>> PRINTING_ENCHANTED_BOOK_COST = DataMapType.builder((ResourceLocation)CSCommon.asResource("printing/enchanted_book/custom_cost"), (ResourceKey)Registries.ENCHANTMENT, (Codec)Codec.list(CSIntIntPair.CODEC)).synced(Codec.list(CSIntIntPair.CODEC), true).build();
    public static final DataMapType<Enchantment, Float> FORGING_COST_MULTIPLIER = DataMapType.builder((ResourceLocation)CSCommon.asResource("forging/cost_multiplier"), (ResourceKey)Registries.ENCHANTMENT, (Codec)ExtraCodecs.POSITIVE_FLOAT).synced(ExtraCodecs.POSITIVE_FLOAT, true).build();
    public static final DataMapType<Enchantment, Float> SPLITTING_COST_MULTIPLIER = DataMapType.builder((ResourceLocation)CSCommon.asResource("forging/split_enchantment_cost_multiplier"), (ResourceKey)Registries.ENCHANTMENT, (Codec)ExtraCodecs.POSITIVE_FLOAT).synced(ExtraCodecs.POSITIVE_FLOAT, true).build();
    public static final DataMapType<Enchantment, Integer> SUPER_ENCHANTING_LEVEL_EXTENSION = DataMapType.builder((ResourceLocation)CSCommon.asResource("super_enchanting/custom_level_extension"), (ResourceKey)Registries.ENCHANTMENT, (Codec)ExtraCodecs.NON_NEGATIVE_INT).synced((Codec)Codec.INT, true).build();

    public static void register(IEventBus modBus) {
        modBus.register(CSDataMaps.class);
        CSCommon.REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, CSDataMaps::generate);
    }

    @SubscribeEvent
    public static void register(RegisterDataMapTypesEvent event) {
        event.register(FLUID_UNIT_EXPERIENCE);
        event.register(PRINTING_ADDRESS_INGREDIENT);
        event.register(PRINTING_PATTERN_INGREDIENT);
        event.register(PRINTING_COPY_INGREDIENT);
        event.register(PRINTING_CUSTOM_NAME_INGREDIENT);
        event.register(PRINTING_CUSTOM_NAME_STYLE);
        event.register(PRINTING_WRITTEN_BOOK_INGREDIENT);
        event.register(PRINTING_ENCHANTED_BOOK_COST);
        event.register(FORGING_COST_MULTIPLIER);
        event.register(SPLITTING_COST_MULTIPLIER);
        event.register(SUPER_ENCHANTING_LEVEL_EXTENSION);
    }

    public static <T> Stream<Pair<Fluid, T>> getSourceFluidEntries(DataMapType<Fluid, T> type) {
        return BuiltInRegistries.FLUID.getDataMap(type).entrySet().stream().map(Pairs.mapKey(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).get(arg_0))).filter(Pairs.filterFirst(fluid -> FluidHelper.convertToStill((Fluid)fluid) == fluid));
    }

    public static void generate(RegistrateDataMapProvider provider) {
        provider.builder(FLUID_UNIT_EXPERIENCE).add(ResourceLocation.fromNamespaceAndPath((String)"cofh_core", (String)"experience"), (Object)25, false, new ICondition[]{new ModLoadedCondition("cofh_core")}).add(ResourceLocation.fromNamespaceAndPath((String)"cyclic", (String)"xpjuice"), (Object)20, false, new ICondition[]{new ModLoadedCondition("cyclic")}).add(ResourceLocation.fromNamespaceAndPath((String)"enderio", (String)"xpjuice"), (Object)20, false, new ICondition[]{new ModLoadedCondition("enderio")}).add(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"essence"), (Object)20, false, new ICondition[]{new ModLoadedCondition("industrialforegoing")}).add(ResourceLocation.fromNamespaceAndPath((String)"mob_grinding_utils", (String)"fluid_xp"), (Object)20, false, new ICondition[]{new ModLoadedCondition("mob_grinding_utils")}).add(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"essence"), (Object)20, false, new ICondition[]{new ModLoadedCondition("industrialforegoing")}).add(ResourceLocation.fromNamespaceAndPath((String)"pneumaticcraft", (String)"memory_essence"), (Object)20, false, new ICondition[]{new ModLoadedCondition("pneumaticcraft")}).add(ResourceLocation.fromNamespaceAndPath((String)"reliquary", (String)"xp_juice_still"), (Object)20, false, new ICondition[]{new ModLoadedCondition("reliquary")}).add(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedcore", (String)"xp_still"), (Object)20, false, new ICondition[]{new ModLoadedCondition("sophisticatedcore")});
        TagKey blackDye = (TagKey)CDPFluids.COMMON_TAGS.dyesByColor.get(DyeColor.BLACK);
        provider.builder(PRINTING_ADDRESS_INGREDIENT).add(blackDye, (Object)10, false, new ICondition[0]);
        provider.builder(PRINTING_PATTERN_INGREDIENT).add(blackDye, (Object)100, false, new ICondition[0]);
        provider.builder(PRINTING_COPY_INGREDIENT).add(blackDye, (Object)10, false, new ICondition[0]);
        provider.builder(PRINTING_WRITTEN_BOOK_INGREDIENT).add(blackDye, (Object)10, false, new ICondition[0]);
        DataMapProvider.Builder customNameStyles = provider.builder(PRINTING_CUSTOM_NAME_STYLE);
        CDPFluids.COMMON_TAGS.dyesByColor.forEach((color, tag) -> customNameStyles.add(tag, (Object)Style.EMPTY.withColor(color.getTextColor()), false, new ICondition[0]));
        provider.builder(PRINTING_ENCHANTED_BOOK_COST);
        provider.builder(FORGING_COST_MULTIPLIER);
        provider.builder(SPLITTING_COST_MULTIPLIER);
        provider.builder(SUPER_ENCHANTING_LEVEL_EXTENSION).add(Enchantments.MENDING, (Object)0, false, new ICondition[0]).add(Enchantments.INFINITY, (Object)0, false, new ICondition[0]);
    }
}

