/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.config;

import com.adonis.createshimmer.config.CSClientConfig;
import com.adonis.createshimmer.config.CSEnchantmentsConfig;
import com.adonis.createshimmer.config.CSFluidsConfig;
import com.adonis.createshimmer.config.CSKineticsConfig;
import com.adonis.createshimmer.config.CSProcessingConfig;
import com.adonis.createshimmer.config.CSRecipesConfig;
import com.adonis.createshimmer.config.CSRepairConfig;
import com.adonis.createshimmer.config.CSServerConfig;
import com.adonis.createshimmer.config.CSStressConfig;
import net.minecraft.Util;
import net.minecraft.util.Unit;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CSConfig {
    private static final CSClientConfig CLIENT_CONFIG = new CSClientConfig();
    private static final CSServerConfig SERVER_CONFIG = new CSServerConfig();
    private static ModConfigSpec CLIENT_SPEC;
    private static ModConfigSpec SERVER_SPEC;

    public CSConfig(ModContainer modContainer) {
        CLIENT_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            CLIENT_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec));
        SERVER_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            SERVER_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec));
    }

    public static CSClientConfig client() {
        return CLIENT_CONFIG;
    }

    public static CSServerConfig server() {
        return SERVER_CONFIG;
    }

    public static CSKineticsConfig kinetics() {
        return CSConfig.SERVER_CONFIG.kinetics;
    }

    public static CSStressConfig stress() {
        return CSConfig.SERVER_CONFIG.kinetics.stressValues;
    }

    public static CSFluidsConfig fluids() {
        return CSConfig.SERVER_CONFIG.fluids;
    }

    public static CSEnchantmentsConfig enchantments() {
        return CSConfig.SERVER_CONFIG.enchantments;
    }

    public static CSProcessingConfig processing() {
        return CSConfig.SERVER_CONFIG.processing;
    }

    public static CSRecipesConfig recipes() {
        return CSConfig.SERVER_CONFIG.recipes;
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (SERVER_SPEC == spec) {
            SERVER_CONFIG.onLoad();
        } else if (CLIENT_SPEC == spec) {
            CLIENT_CONFIG.onLoad();
        }
    }

    public static CSRepairConfig repair() {
        return CSConfig.server().repair;
    }

    @SubscribeEvent
    public void onReload(ModConfigEvent.Reloading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (SERVER_SPEC == spec) {
            SERVER_CONFIG.onReload();
        } else if (CLIENT_SPEC == spec) {
            CLIENT_CONFIG.onReload();
        }
    }
}

