/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.integration.jei.category;

import com.adonis.createshimmer.common.CSCommon;
import com.adonis.createshimmer.common.registry.CSRecipes;
import com.adonis.createshimmer.config.CSConfig;
import com.adonis.createshimmer.integration.jei.category.FanGloomingCategory;
import com.adonis.createshimmer.integration.jei.category.FanTransmutationCategory;
import com.google.common.base.Preconditions;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.ApiStatus;
import plus.dragons.createdragonsplus.util.ErrorMessages;

@JeiPlugin
public class CSJeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = CSCommon.asResource("jei");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (((Boolean)CSConfig.recipes().enableBulkTransmutation.get()).booleanValue()) {
            FanTransmutationCategory transmutationCategory = FanTransmutationCategory.create();
            registration.addRecipeCategories(new IRecipeCategory[]{transmutationCategory});
        }
        if (((Boolean)CSConfig.recipes().enableBulkGlooming.get()).booleanValue()) {
            FanGloomingCategory gloomingCategory = FanGloomingCategory.create();
            registration.addRecipeCategories(new IRecipeCategory[]{gloomingCategory});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = CSJeiPlugin.getRecipeManager();
        Optional manualApplication = registration.getJeiHelpers().getRecipeType(Create.asResource((String)"item_application"), ItemApplicationRecipe.class);
        if (((Boolean)CSConfig.recipes().enableBulkTransmutation.get()).booleanValue()) {
            List transmutationRecipes = recipeManager.getAllRecipesFor(CSRecipes.TRANSMUTATION.getType());
            registration.addRecipes(FanTransmutationCategory.TYPE, transmutationRecipes);
        }
        if (((Boolean)CSConfig.recipes().enableBulkGlooming.get()).booleanValue()) {
            List gloomingRecipes = recipeManager.getAllRecipesFor(CSRecipes.GLOOMING.getType());
            registration.addRecipes(FanGloomingCategory.TYPE, gloomingRecipes);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (((Boolean)CSConfig.recipes().enableBulkTransmutation.get()).booleanValue()) {
            registration.addRecipeCatalysts(FanTransmutationCategory.TYPE, new ItemLike[]{AllBlocks.ENCASED_FAN});
        }
        if (((Boolean)CSConfig.recipes().enableBulkGlooming.get()).booleanValue()) {
            registration.addRecipeCatalysts(FanGloomingCategory.TYPE, new ItemLike[]{AllBlocks.ENCASED_FAN});
        }
    }

    @ApiStatus.Internal
    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving recipe manager from client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)ErrorMessages.notNull((String)"minecraft"));
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)ErrorMessages.notNull((String)"level"));
        return level.getRecipeManager();
    }
}

