/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected;

import com.hlysine.create_connected.CCSoundEvents;
import com.hlysine.create_connected.CreateConnected;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.JsonCodecProvider;

public class CCJukeboxSongs {
    private static final Map<ResourceKey<JukeboxSong>, JukeboxSong> JUKEBOX_SONGS = new HashMap<ResourceKey<JukeboxSong>, JukeboxSong>();
    public static final ResourceKey<JukeboxSong> INTERLUDE = CCJukeboxSongs.register("interlude", CCSoundEvents.INTERLUDE_MUSIC.getMainEventHolder(), 189, 14);
    public static final ResourceKey<JukeboxSong> ELEVATOR = CCJukeboxSongs.register("elevator", CCSoundEvents.ELEVATOR_MUSIC.getMainEventHolder(), 240, 15);

    private static ResourceKey<JukeboxSong> register(String key, Holder<SoundEvent> soundEvent, int lengthInSeconds, int comparatorOutput) {
        ResourceKey songKey = ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)CreateConnected.asResource(key));
        JUKEBOX_SONGS.put((ResourceKey<JukeboxSong>)songKey, new JukeboxSong(soundEvent, (Component)Component.translatable((String)CCJukeboxSongs.translationId(key)), (float)lengthInSeconds, comparatorOutput));
        return songKey;
    }

    private static String translationId(String key) {
        return "item.create_connected.music_disc_" + key + ".desc";
    }

    public static JukeboxSongProvider provider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        return new JukeboxSongProvider(output, lookupProvider, existingFileHelper);
    }

    public static class JukeboxSongProvider
    extends JsonCodecProvider<JukeboxSong> {
        public JukeboxSongProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
            super(output, PackOutput.Target.DATA_PACK, "jukebox_song", PackType.SERVER_DATA, JukeboxSong.DIRECT_CODEC, lookupProvider, "create_connected", existingFileHelper);
        }

        protected void gather() {
            for (Map.Entry<ResourceKey<JukeboxSong>, JukeboxSong> entry : JUKEBOX_SONGS.entrySet()) {
                this.unconditional(entry.getKey().location(), entry.getValue());
            }
        }
    }
}

