/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.plough;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.actors.plough.PloughMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import io.github.cotrin8672.cem.config.CemConfig;
import io.github.cotrin8672.cem.content.block.plough.EnchantablePloughRenderer;
import io.github.cotrin8672.cem.util.EnchantedItemFactory;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006H\u0014J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J(\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/cotrin8672/cem/content/block/plough/EnchantablePloughMovementBehaviour;", "Lcom/simibubi/create/content/contraptions/actors/plough/PloughMovementBehaviour;", "<init>", "()V", "enchantedTools", "", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "Lnet/minecraft/world/item/ItemStack;", "destroyBlock", "", "context", "breakingPos", "Lnet/minecraft/core/BlockPos;", "getBlockBreakingSpeed", "", "canBeDisabledVia", "renderInContraption", "renderWorld", "Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;", "matrices", "Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "createenchantablemachinery"})
public final class EnchantablePloughMovementBehaviour
extends PloughMovementBehaviour {
    @NotNull
    private final Map<MovementContext, ItemStack> enchantedTools = new WeakHashMap();

    protected void destroyBlock(@Nullable MovementContext context, @Nullable BlockPos breakingPos) {
        if (context == null) {
            return;
        }
        if (this.enchantedTools.get(context) == null) {
            this.enchantedTools.put(context, EnchantedItemFactory.INSTANCE.getPickaxeItemStack(context.blockEntityData, context));
        }
        BlockHelper.destroyBlockAs((Level)context.world, (BlockPos)breakingPos, null, (ItemStack)this.enchantedTools.get(context), (float)1.0f, arg_0 -> EnchantablePloughMovementBehaviour.destroyBlock$lambda$0(this, context, arg_0));
    }

    protected float getBlockBreakingSpeed(@NotNull MovementContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.enchantedTools.get(context) == null) {
            this.enchantedTools.put(context, EnchantedItemFactory.INSTANCE.getPickaxeItemStack(context.blockEntityData, context));
        }
        HolderLookup holderLookup = context.world.holderLookup(Registries.ENCHANTMENT);
        Optional optional = holderLookup.get(Enchantments.EFFICIENCY);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"get(...)");
        Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
        if (reference == null) {
            return super.getBlockBreakingSpeed(context);
        }
        Holder.Reference holder = reference;
        ItemStack itemStack = this.enchantedTools.get(context);
        if (itemStack == null) {
            return super.getBlockBreakingSpeed(context);
        }
        int efficiencyLevel = itemStack.getEnchantmentLevel((Holder)holder);
        return super.getBlockBreakingSpeed(context) * (float)(efficiencyLevel + 1);
    }

    @Nullable
    public ItemStack canBeDisabledVia(@Nullable MovementContext context) {
        return AllBlocks.MECHANICAL_PLOUGH.asStack();
    }

    public void renderInContraption(@NotNull MovementContext context, @NotNull VirtualRenderWorld renderWorld, @NotNull ContraptionMatrices matrices, @NotNull MultiBufferSource buffer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderWorld, (String)"renderWorld");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderInContraption(context, renderWorld, matrices, buffer);
        if (((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue() && !VisualizationManager.supportsVisualization((LevelAccessor)((LevelAccessor)context.world))) {
            EnchantablePloughRenderer.Companion.renderInContraption(context, matrices, buffer);
        }
    }

    private static final void destroyBlock$lambda$0(EnchantablePloughMovementBehaviour this$0, MovementContext $context, ItemStack it) {
        this$0.dropItem($context, it);
    }
}

