/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.block;

import dev.satherov.crystalix.core.CSRegistry;
import dev.satherov.crystalix.core.annotations.NothingNull;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NothingNull
public class CrystalixGlassTile
extends BlockEntity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CrystalixGlassTile.class);
    private static final ModelProperty<Integer> COLOR = new ModelProperty();
    private int color = 0xFFFFFF;
    private boolean reinforced = false;
    private boolean conductor = false;

    public CrystalixGlassTile(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)CSRegistry.GLASS_TILE.get(), pos, blockState);
    }

    public void setColor(BlockState state, int color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setAndUpdate(state);
    }

    public void setReinforced(boolean reinforced) {
        if (this.reinforced == reinforced) {
            return;
        }
        this.reinforced = reinforced;
        this.setAndUpdate(this.getBlockState());
    }

    public void setConductor(boolean conductor) {
        if (this.conductor == conductor) {
            return;
        }
        this.conductor = conductor;
        this.setAndUpdate(this.getBlockState());
    }

    private void setAndUpdate(BlockState state) {
        this.setChanged();
        if (this.level == null) {
            return;
        }
        this.level.setBlock(this.worldPosition, state, 11);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("color", this.color);
        tag.putBoolean("reinforced", this.reinforced);
        tag.putBoolean("conductor", this.conductor);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("color")) {
            this.color = tag.getInt("color");
        }
        if (tag.contains("reinforced")) {
            this.reinforced = tag.getBoolean("reinforced");
        }
        if (tag.contains("conductor")) {
            this.conductor = tag.getBoolean("conductor");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
        if (this.level != null && this.level.isClientSide()) {
            Minecraft.getInstance().levelRenderer.blockChanged((BlockGetter)this.level, this.worldPosition, this.getBlockState(), this.getBlockState(), 8);
        }
    }

    public ModelData getModelData() {
        return ModelData.builder().with(COLOR, (Object)this.color).build();
    }

    public static BlockBehaviour.StatePredicate isRedstoneConductor() {
        return (state, getter, pos) -> {
            CrystalixGlassTile tile;
            BlockEntity patt0$temp = getter.getBlockEntity(pos);
            return patt0$temp instanceof CrystalixGlassTile && (tile = (CrystalixGlassTile)patt0$temp).isConductor();
        };
    }

    public static boolean isReinforced(BlockGetter getter, BlockPos pos) {
        CrystalixGlassTile tile;
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        return blockEntity instanceof CrystalixGlassTile && (tile = (CrystalixGlassTile)blockEntity).isReinforced();
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public boolean isReinforced() {
        return this.reinforced;
    }

    @Generated
    public boolean isConductor() {
        return this.conductor;
    }
}

