/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.properties;

import com.mojang.serialization.Codec;
import dev.satherov.crystalix.Crystalix;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.client.lang.CSTranslatable;
import dev.satherov.crystalix.common.properties.CSBooleanProperty;
import dev.satherov.crystalix.common.properties.CSEnumProperty;
import dev.satherov.crystalix.common.properties.CSIntegerProperty;
import dev.satherov.crystalix.common.properties.EnumCodecs;
import dev.satherov.crystalix.common.properties.IProperty;
import dev.satherov.crystalix.core.CSRegistry;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import org.jetbrains.annotations.NotNull;

public final class CSProperties {
    public static final ResourceLocation INVISIBLE = Crystalix.rl("invisible");
    public static final ResourceLocation CLEAR = Crystalix.rl("clear");
    public static final ResourceLocation WATERLOGGABLE = Crystalix.rl("waterloggable");
    public static final ResourceLocation REINFORCED = Crystalix.rl("reinforced");
    public static final ResourceLocation SHADELESS = Crystalix.rl("shadeless");
    public static final ResourceLocation REDSTONE = Crystalix.rl("redstone");
    public static final ResourceLocation CONDUCTOR = Crystalix.rl("conductor");
    public static final ResourceLocation GHOST = Crystalix.rl("ghost");
    public static final ResourceLocation LIGHT = Crystalix.rl("light");
    public static final ResourceLocation COLOR = Crystalix.rl("color");
    private final Map<ResourceLocation, IProperty<?>> properties;
    private final CSBooleanProperty waterloggable;
    private final CSBooleanProperty invisible;
    private final CSBooleanProperty shadeless;
    private final CSBooleanProperty redstone;
    private final CSBooleanProperty conductor;
    private final CSBooleanProperty reinforced;
    private final CSBooleanProperty clear;
    private final CSEnumProperty<Ghost> ghost;
    private final CSEnumProperty<Light> light;
    private final CSIntegerProperty color;

    private CSProperties(ItemStack stack) {
        this.invisible = CSBooleanProperty.create(stack, CSLanguage.PROPERTY_INVISIBLE, CSLanguage.PROPERTY_INVISIBLE_TOOLTIP, INVISIBLE, false, CSRegistry.INVISIBLE);
        this.waterloggable = CSBooleanProperty.create(stack, CSLanguage.PROPERTY_WATERLOGGABLE, CSLanguage.PROPERTY_WATERLOGGABLE_TOOLTIP, WATERLOGGABLE, false, CSRegistry.WATERLOGGABLE);
        this.clear = CSBooleanProperty.create(stack, CSLanguage.PROPERTY_TRANSPARENT, CSLanguage.PROPERTY_TRANSPARENT_TOOLTIP, CLEAR, true, CSRegistry.TRANSPARENT);
        this.shadeless = CSBooleanProperty.create(stack, CSLanguage.PROPERTY_SHADELESS, CSLanguage.PROPERTY_SHADELESS_TOOLTIP, SHADELESS, false, CSRegistry.SHADELESS);
        this.reinforced = CSBooleanProperty.create(stack, CSLanguage.PROPERTY_REINFORCED, CSLanguage.PROPERTY_REINFORCED_TOOLTIP, REINFORCED, false, CSRegistry.REINFORCED);
        this.redstone = CSBooleanProperty.create(stack, CSLanguage.PROPERTY_REDSTONE, CSLanguage.PROPERTY_REDSTONE_TOOLTIP, REDSTONE, false, CSRegistry.REDSTONE);
        this.conductor = CSBooleanProperty.create(stack, CSLanguage.PROPERTY_CONDUCTOR, CSLanguage.PROPERTY_CONDUCTOR_TOOLTIP, CONDUCTOR, false, CSRegistry.CONDUCTOR);
        this.ghost = CSEnumProperty.create(stack, CSLanguage.PROPERTY_GHOST, CSLanguage.PROPERTY_GHOST_TOOLTIP, GHOST, Ghost.class, Ghost.BLOCK_ALL, CSRegistry.GHOST);
        this.light = CSEnumProperty.create(stack, CSLanguage.PROPERTY_LIGHT, CSLanguage.PROPERTY_LIGHT_TOOLTIP, LIGHT, Light.class, Light.NONE, CSRegistry.LIGHT);
        this.color = CSIntegerProperty.create(stack, CSLanguage.PROPERTY_COLOR, CSLanguage.PROPERTY_COLOR_TOOLTIP, COLOR, 0xFFFFFF, CSRegistry.COLOR);
        this.properties = new LinkedHashMap<ResourceLocation, IProperty<?>>(){
            {
                this.put(INVISIBLE, CSProperties.this.invisible);
                this.put(CLEAR, CSProperties.this.clear);
                this.put(WATERLOGGABLE, CSProperties.this.waterloggable);
                this.put(REINFORCED, CSProperties.this.reinforced);
                this.put(SHADELESS, CSProperties.this.shadeless);
                this.put(REDSTONE, CSProperties.this.redstone);
                this.put(CONDUCTOR, CSProperties.this.conductor);
                this.put(GHOST, CSProperties.this.ghost);
                this.put(LIGHT, CSProperties.this.light);
                this.put(COLOR, CSProperties.this.color);
            }
        };
    }

    public static CSProperties of(ItemStack stack) {
        return new CSProperties(stack);
    }

    public IProperty<?> get(int index) {
        return ((IProperty[])this.properties.values().toArray(IProperty[]::new))[index];
    }

    @Generated
    public Map<ResourceLocation, IProperty<?>> properties() {
        return this.properties;
    }

    @Generated
    public CSBooleanProperty waterloggable() {
        return this.waterloggable;
    }

    @Generated
    public CSBooleanProperty invisible() {
        return this.invisible;
    }

    @Generated
    public CSBooleanProperty shadeless() {
        return this.shadeless;
    }

    @Generated
    public CSBooleanProperty redstone() {
        return this.redstone;
    }

    @Generated
    public CSBooleanProperty conductor() {
        return this.conductor;
    }

    @Generated
    public CSBooleanProperty reinforced() {
        return this.reinforced;
    }

    @Generated
    public CSBooleanProperty clear() {
        return this.clear;
    }

    @Generated
    public CSEnumProperty<Ghost> ghost() {
        return this.ghost;
    }

    @Generated
    public CSEnumProperty<Light> light() {
        return this.light;
    }

    @Generated
    public CSIntegerProperty color() {
        return this.color;
    }

    public static enum Ghost implements StringRepresentable,
    CSTranslatable
    {
        BLOCK_ALL(CSLanguage.PROPERTY_GHOST_ALL, ChatFormatting.DARK_GRAY, false, context -> false),
        ALLOW_ALL(CSLanguage.PROPERTY_GHOST_ALL, ChatFormatting.DARK_GRAY, true, context -> true),
        BLOCK_PLAYER(CSLanguage.PROPERTY_GHOST_PLAYER, ChatFormatting.AQUA, false, context -> !(context.getEntity() instanceof Player)),
        ALLOW_PLAYER(CSLanguage.PROPERTY_GHOST_PLAYER, ChatFormatting.AQUA, true, context -> context.getEntity() instanceof Player),
        BLOCK_MONSTER(CSLanguage.PROPERTY_GHOST_MONSTER, ChatFormatting.RED, false, context -> !(context.getEntity() instanceof Monster)),
        ALLOW_MONSTER(CSLanguage.PROPERTY_GHOST_MONSTER, ChatFormatting.RED, true, context -> context.getEntity() instanceof Monster),
        BLOCK_ANIMAL(CSLanguage.PROPERTY_GHOST_ANIMAL, ChatFormatting.GREEN, false, context -> !(context.getEntity() instanceof Animal)),
        ALLOW_ANIMAL(CSLanguage.PROPERTY_GHOST_ANIMAL, ChatFormatting.GREEN, true, context -> context.getEntity() instanceof Animal);

        public static final Codec<Ghost> CODEC;
        public static final StreamCodec<ByteBuf, Ghost> STREAM_CODEC;
        private final String key;
        private final String translation;
        private final ChatFormatting color;
        private final boolean state;
        private final Predicate<EntityCollisionContext> collisionPredicate;

        private Ghost(CSLanguage language, ChatFormatting color, boolean state, Predicate<EntityCollisionContext> collisionPredicate) {
            this.key = language.key();
            this.translation = language.translation();
            this.color = color;
            this.state = state;
            this.collisionPredicate = collisionPredicate;
        }

        public boolean canCollide(EntityCollisionContext context) {
            return this.collisionPredicate.test(context);
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public MutableComponent text() {
            MutableComponent component = Component.empty();
            component.append((Component)(this.state ? CSLanguage.PROPERTY_ALLOW.text(ChatFormatting.GREEN) : CSLanguage.PROPERTY_DENY.text(ChatFormatting.RED)));
            component.append(" ");
            component.append((Component)CSTranslatable.super.text(this.color));
            return component;
        }

        @Override
        @Generated
        public String key() {
            return this.key;
        }

        @Override
        @Generated
        public String translation() {
            return this.translation;
        }

        @Generated
        public ChatFormatting color() {
            return this.color;
        }

        static {
            CODEC = EnumCodecs.makeCodec(Ghost.class);
            STREAM_CODEC = EnumCodecs.makeStreamCodec(Ghost.class);
        }
    }

    public static enum Light implements StringRepresentable,
    CSTranslatable
    {
        NONE(CSLanguage.PROPERTY_LIGHT_NONE, ChatFormatting.GRAY),
        LIGHT(CSLanguage.PROPERTY_LIGHT_LIGHT, ChatFormatting.GOLD),
        DARK(CSLanguage.PROPERTY_LIGHT_DARK, ChatFormatting.DARK_GRAY),
        FAKE_LIGHT(CSLanguage.PROPERTY_LIGHT_FAKE, ChatFormatting.LIGHT_PURPLE);

        public static final Codec<Light> CODEC;
        public static final StreamCodec<ByteBuf, Light> STREAM_CODEC;
        private final String key;
        private final String translation;
        private final ChatFormatting color;

        private Light(CSLanguage language, ChatFormatting color) {
            this.key = language.key();
            this.translation = language.translation();
            this.color = color;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public MutableComponent text() {
            return CSTranslatable.super.text(this.color);
        }

        @Override
        @Generated
        public String key() {
            return this.key;
        }

        @Override
        @Generated
        public String translation() {
            return this.translation;
        }

        @Generated
        public ChatFormatting color() {
            return this.color;
        }

        static {
            CODEC = EnumCodecs.makeCodec(Light.class);
            STREAM_CODEC = EnumCodecs.makeStreamCodec(Light.class);
        }
    }
}

