/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.custommachineryars.client.screen.creation.component.builder;

import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import es.degrassi.custommachineryars.Registration;
import es.degrassi.custommachineryars.components.SourceMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SourceComponentBuilder
implements IMachineComponentBuilder<SourceMachineComponent, SourceMachineComponent.Template> {
    public MachineComponentType<SourceMachineComponent> type() {
        return Registration.SOURCE_MACHINE_COMPONENT.get();
    }

    public PopupScreen makePopup(MachineEditScreen machineEditScreen, @Nullable SourceMachineComponent.Template template, Consumer<SourceMachineComponent.Template> consumer) {
        return new SourceComponentBuilderPopup((BaseScreen)machineEditScreen, template, consumer);
    }

    public void render(GuiGraphics graphics, int x, int y, int width, int height, SourceMachineComponent.Template template) {
        graphics.renderFakeItem(BlockRegistry.SOURCE_JAR.asItem().getDefaultInstance(), x, y + height / 2 - 8);
        graphics.drawString(Minecraft.getInstance().font, "type: " + template.getType().getId().getPath(), x + 25, y + 5, 0, false);
    }

    public static class SourceComponentBuilderPopup
    extends ComponentBuilderPopup<SourceMachineComponent.Template> {
        private EditBox capacity;
        private EditBox maxInput;
        private EditBox maxOutput;

        public SourceComponentBuilderPopup(BaseScreen parent, SourceMachineComponent.Template template, Consumer<SourceMachineComponent.Template> onFinish) {
            super(parent, (IMachineComponentTemplate)template, onFinish, (Component)Component.translatable((String)"custommachineryars.gui.creation.components.source.title"));
        }

        public SourceMachineComponent.Template makeTemplate() {
            return new SourceMachineComponent.Template((int)this.parseLong(this.capacity.getValue()), (int)this.parseLong(this.maxInput.getValue()), (int)this.parseLong(this.maxOutput.getValue()));
        }

        protected void init() {
            super.init();
            this.capacity = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.capacity"), (AbstractWidget)new EditBox(this.font, 0, 0, 160, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.capacity")));
            this.capacity.setFilter(arg_0 -> ((SourceComponentBuilderPopup)this).checkLong(arg_0));
            this.baseTemplate().ifPresentOrElse(template -> this.capacity.setValue("" + template.capacity()), () -> this.capacity.setValue("10000"));
            this.maxInput = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.maxInput"), (AbstractWidget)new EditBox(this.font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.maxInput")));
            this.maxInput.setFilter(arg_0 -> ((SourceComponentBuilderPopup)this).checkLong(arg_0));
            this.baseTemplate().ifPresentOrElse(template -> this.maxInput.setValue("" + template.maxInput()), () -> this.maxInput.setValue("10000"));
            this.maxOutput = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.maxOutput"), (AbstractWidget)new EditBox(this.font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.maxOutput")));
            this.maxOutput.setFilter(arg_0 -> ((SourceComponentBuilderPopup)this).checkLong(arg_0));
            this.baseTemplate().ifPresentOrElse(template -> this.maxOutput.setValue("" + template.maxOutput()), () -> this.maxOutput.setValue("10000"));
        }
    }
}

