/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.custommachineryars.util;

import com.hollingsworth.arsnouveau.common.items.data.BlockFillContents;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import es.degrassi.custommachineryars.components.SourceMachineComponent;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class SourceHelper {
    public static final SourceHelper INSTANCE = new SourceHelper();

    private SourceHelper() {
    }

    public void fillBufferFromStack(SourceMachineComponent buffer, ItemStack stack) {
        BlockFillContents newContent;
        BlockFillContents tag = (BlockFillContents)stack.getComponents().get((DataComponentType)DataComponentRegistry.BLOCK_FILL_CONTENTS.get());
        int itemCount = stack.getCount();
        if (tag == null) {
            return;
        }
        int source = tag.amount() * itemCount;
        int received = buffer.receiveSource(source, true);
        if (received == source) {
            newContent = new BlockFillContents(0);
            buffer.receiveSource(source);
        } else {
            buffer.receiveSource(received);
            newContent = new BlockFillContents((source - received) / itemCount);
        }
        stack.set((DataComponentType)DataComponentRegistry.BLOCK_FILL_CONTENTS.get(), (Object)newContent);
    }

    public void fillStackFromBuffer(ItemStack stack, SourceMachineComponent buffer) {
        BlockFillContents newContent;
        int stackCapacity;
        BlockFillContents nbt = (BlockFillContents)stack.getComponents().get((DataComponentType)DataComponentRegistry.BLOCK_FILL_CONTENTS.get());
        if (nbt == null) {
            return;
        }
        int stackSource = nbt.amount();
        int n = stackCapacity = stack.is(BlockRegistry.SOURCE_JAR.asItem()) ? 10000 : 0;
        if (stackSource == stackCapacity || stackCapacity == 0) {
            return;
        }
        int itemCount = stack.getCount();
        int possibleReceive = (stackCapacity - stackSource) * itemCount;
        if (buffer.extractSource(possibleReceive, true) == possibleReceive) {
            buffer.extractSource(possibleReceive);
            newContent = new BlockFillContents(stackCapacity);
        } else {
            int extract = buffer.extractSource(possibleReceive, true);
            if (extract < possibleReceive) {
                buffer.extractSource(extract);
                newContent = new BlockFillContents(stackSource + extract / itemCount);
            } else {
                newContent = nbt;
            }
        }
        stack.set((DataComponentType)DataComponentRegistry.BLOCK_FILL_CONTENTS.get(), (Object)newContent);
    }
}

