/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden.conditions;

import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.hidden.HiddenCondition;
import com.cmdpro.databank.hidden.HiddenSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;

public class NotCondition
extends HiddenCondition {
    public HiddenCondition condition;

    public NotCondition(HiddenCondition condition) {
        this.condition = condition;
    }

    @Override
    public boolean isUnlocked(Player player) {
        return !this.condition.isUnlocked(player);
    }

    @Override
    public HiddenCondition.Serializer<?> getSerializer() {
        return NotConditionSerializer.INSTANCE;
    }

    public static class NotConditionSerializer
    extends HiddenCondition.Serializer {
        public static final NotConditionSerializer INSTANCE = new NotConditionSerializer();
        public static final MapCodec<NotCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HiddenSerializer.HIDDEN_CONDITION_CODEC.fieldOf("condition").forGetter(condition -> condition.condition)).apply((Applicative)instance, NotCondition::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, NotCondition> STREAM_CODEC = StreamCodec.of((buf, value) -> {
            buf.writeResourceKey((ResourceKey)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.getResourceKey((Object)value.condition.getSerializer()).orElseThrow());
            value.condition.getSerializer().streamCodec().encode(buf, (Object)value.condition);
        }, buf -> {
            ResourceKey conditionKey = buf.readResourceKey(DatabankRegistries.HIDDEN_CONDITION_REGISTRY_KEY);
            HiddenCondition.Serializer conditionSerializer = (HiddenCondition.Serializer)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.get(conditionKey);
            HiddenCondition condition = (HiddenCondition)conditionSerializer.streamCodec().decode(buf);
            return new NotCondition(condition);
        });

        public MapCodec<NotCondition> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, NotCondition> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

