/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.impact;

import com.cmdpro.databank.config.DatabankClientConfig;
import com.cmdpro.databank.impact.ImpactShader;
import com.cmdpro.databank.misc.FloatGradient;
import com.cmdpro.databank.mixin.client.BufferSourceMixin;
import com.cmdpro.databank.shaders.PostShaderManager;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedMap;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class ImpactFrameHandler {
    public static final ImpactShader defaultShader = new ImpactShader();
    public static ImpactFrame impactFrame;
    private static final List<ImpactData> impactData;
    private static RenderTarget impactTarget;
    private static RenderTarget frozenImpactTarget;
    private static MultiBufferSource.BufferSource bufferSource;
    private static boolean reset;

    public static void resize(int width, int height) {
        ImpactFrameHandler.getImpactTarget().resize(width, height, Minecraft.ON_OSX);
        ImpactFrameHandler.getFrozenImpactTarget().resize(width, height, Minecraft.ON_OSX);
    }

    public static ImpactFrame addImpact(int ticks, ImpactRender frozenRender, ImpactRender dynamicRender, FloatGradient alpha, boolean merge, ImpactShader shader) {
        impactData.add(new ImpactData(frozenRender, dynamicRender, merge));
        reset = false;
        if (impactFrame != null) {
            ImpactFrameHandler.impactFrame.shader.setActive(false);
        }
        impactFrame = new ImpactFrame(ticks, shader, alpha);
        shader.setActive(true);
        return impactFrame;
    }

    public static ImpactFrame addImpact(int ticks, ImpactRender frozenRender, ImpactRender dynamicRender, FloatGradient alpha) {
        return ImpactFrameHandler.addImpact(ticks, frozenRender, dynamicRender, alpha, false, defaultShader);
    }

    public static ImpactFrame addImpact(int ticks, ImpactRender frozenRender, ImpactRender dynamicRender, FloatGradient alpha, boolean merge) {
        return ImpactFrameHandler.addImpact(ticks, frozenRender, dynamicRender, alpha, merge, defaultShader);
    }

    public static ImpactFrame addImpact(int ticks, ImpactRender frozenRender, ImpactRender dynamicRender, FloatGradient alpha, ImpactShader shader) {
        return ImpactFrameHandler.addImpact(ticks, frozenRender, dynamicRender, alpha, false, shader);
    }

    public static ImpactFrame withFlashes(ImpactFrame original, float[] flashes, float flashTime) {
        ImpactFrameHandler.withFlashes(original.alpha, original.startTicks, flashes, flashTime);
        return original;
    }

    public static FloatGradient withFlashes(FloatGradient original, float seconds, float[] flashes, float flashTime) {
        if (!DatabankClientConfig.allowFlashOnImpactVisuals) {
            return original;
        }
        float flash = flashTime / seconds;
        for (float i : flashes) {
            float progress = i / seconds;
            float alpha = ((Float)original.getValue(progress)).floatValue();
            original.addPoint(Float.valueOf(0.0f), progress, true);
            original.addPoint(Float.valueOf(alpha), progress + flash, true);
        }
        return original;
    }

    public static FloatGradient withFlashes(FloatGradient original, int ticks, float[] flashes, float flashTime) {
        return ImpactFrameHandler.withFlashes(original, (float)ticks / 20.0f, flashes, flashTime);
    }

    protected static RenderTarget getImpactTarget() {
        if (impactTarget == null) {
            int width = Minecraft.getInstance().getMainRenderTarget().width;
            int height = Minecraft.getInstance().getMainRenderTarget().height;
            impactTarget = new MainTarget(width, height);
            impactTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return impactTarget;
    }

    protected static RenderTarget getFrozenImpactTarget() {
        if (frozenImpactTarget == null) {
            int width = Minecraft.getInstance().getMainRenderTarget().width;
            int height = Minecraft.getInstance().getMainRenderTarget().height;
            frozenImpactTarget = new MainTarget(width, height);
            frozenImpactTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return frozenImpactTarget;
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        BufferSourceMixin mixin = (BufferSourceMixin)original;
        ByteBufferBuilder fallback = mixin.getSharedBuffer();
        SequencedMap<RenderType, ByteBufferBuilder> fixedBuffers = mixin.getFixedBuffers();
        return MultiBufferSource.immediateWithBuffers(fixedBuffers, (ByteBufferBuilder)fallback);
    }

    protected static void renderData(ImpactData data, boolean dynamic, RenderLevelStageEvent event) {
        RenderTarget impactTarget;
        RenderTarget renderTarget = impactTarget = dynamic ? ImpactFrameHandler.getImpactTarget() : ImpactFrameHandler.getFrozenImpactTarget();
        if (!data.merge) {
            impactTarget.clear(Minecraft.ON_OSX);
        }
        impactTarget.bindWrite(true);
        event.getPoseStack().pushPose();
        Vec3 pos = event.getCamera().getPosition();
        event.getPoseStack().pushPose();
        event.getPoseStack().translate(-pos.x, -pos.y, -pos.z);
        if (bufferSource == null) {
            bufferSource = ImpactFrameHandler.initBuffers(Minecraft.getInstance().renderBuffers().bufferSource());
        }
        (dynamic ? data.renderDynamic : data.renderFrozen).renderFrame(impactTarget, (MultiBufferSource)bufferSource, event.getPoseStack(), event.getPartialTick(), event.getCamera(), event.getFrustum(), event.getRenderTick(), impactFrame.getProgress(event.getPartialTick().getGameTimeDeltaPartialTick(true)));
        bufferSource.endBatch();
        event.getPoseStack().popPose();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
    }

    static {
        impactData = new ArrayList<ImpactData>();
    }

    protected record ImpactData(ImpactRender renderFrozen, ImpactRender renderDynamic, boolean merge) {
    }

    public static interface ImpactRender {
        public void renderFrame(RenderTarget var1, MultiBufferSource var2, PoseStack var3, DeltaTracker var4, Camera var5, Frustum var6, int var7, float var8);
    }

    public static class ImpactFrame {
        public int startTicks;
        public int ticks;
        public ImpactShader shader;
        public FloatGradient alpha;
        protected List<ImpactData> impactData = new ArrayList<ImpactData>();

        protected ImpactFrame(int startTicks, ImpactShader shader, FloatGradient alpha) {
            this.startTicks = startTicks;
            this.ticks = startTicks;
            this.shader = shader;
            this.alpha = alpha;
        }

        protected void tick() {
            --this.ticks;
        }

        public ImpactFrame withFlashes(float[] flashes, float flashTime) {
            ImpactFrameHandler.withFlashes(this, flashes, flashTime);
            return this;
        }

        public float getProgress(float partialTick) {
            float maxProgress = (float)ImpactFrameHandler.impactFrame.startTicks / 20.0f;
            return (float)(this.startTicks - this.ticks) / 20.0f / maxProgress;
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="databank", bus=EventBusSubscriber.Bus.MOD)
    protected static class ModEvents {
        protected ModEvents() {
        }

        @SubscribeEvent
        public static void doSetup(FMLClientSetupEvent event) {
            PostShaderManager.addShader(defaultShader);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="databank", bus=EventBusSubscriber.Bus.GAME)
    protected static class GameEvents {
        protected GameEvents() {
        }

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Pre event) {
            if (impactFrame != null) {
                impactFrame.tick();
                if (ImpactFrameHandler.impactFrame.ticks <= 0) {
                    ImpactFrameHandler.impactFrame.shader.setActive(false);
                    impactFrame = null;
                    reset = false;
                }
            }
        }

        @SubscribeEvent
        public static void onRender(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && impactFrame != null) {
                if (!impactData.isEmpty()) {
                    ImpactFrameHandler.getFrozenImpactTarget().clear(Minecraft.ON_OSX);
                    for (ImpactData data : impactData) {
                        ImpactFrameHandler.renderData(data, false, event);
                    }
                    ImpactFrameHandler.impactFrame.impactData.addAll(impactData);
                    impactData.clear();
                }
                if (!ImpactFrameHandler.impactFrame.shader.isActive()) {
                    ImpactFrameHandler.impactFrame.shader.setActive(true);
                }
                if ((double)((Float)ImpactFrameHandler.impactFrame.alpha.getValue(ImpactFrameHandler.impactFrame.shader.getTime())).floatValue() <= 0.1) {
                    reset = true;
                } else if (reset) {
                    ImpactFrameHandler.getFrozenImpactTarget().clear(Minecraft.ON_OSX);
                    for (ImpactData data : impactData) {
                        ImpactFrameHandler.renderData(data, false, event);
                    }
                    reset = false;
                }
                ImpactFrameHandler.getImpactTarget().clear(Minecraft.ON_OSX);
                ImpactFrameHandler.getImpactTarget().copyDepthFrom(ImpactFrameHandler.getFrozenImpactTarget());
                for (ImpactData i : ImpactFrameHandler.impactFrame.impactData) {
                    ImpactFrameHandler.renderData(i, true, event);
                }
            }
        }
    }
}

