/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.config.DatabankClientConfig;
import com.cmdpro.databank.misc.FloatGradient;
import com.mojang.blaze3d.Blaze3D;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

public class ScreenshakeHandler {
    public static List<Screenshake> screenshakes = new ArrayList<Screenshake>();

    public static Screenshake addScreenshake(int time, int delay, FloatGradient intensity) {
        Screenshake screenshake = new Screenshake(time, delay, intensity);
        screenshakes.add(screenshake);
        return screenshake;
    }

    public static Screenshake addScreenshake(int time, int delay, float startIntensity) {
        Screenshake screenshake = new Screenshake(delay, time, FloatGradient.singleValue(Float.valueOf(startIntensity)).fade(1.0f, 0.0f));
        screenshakes.add(screenshake);
        return screenshake;
    }

    public static Screenshake addScreenshake(int time, float startIntensity) {
        Screenshake screenshake = new Screenshake(0, time, FloatGradient.singleValue(Float.valueOf(startIntensity)).fade(1.0f, 0.0f));
        screenshakes.add(screenshake);
        return screenshake;
    }

    public static Screenshake addScreenshake(int time, FloatGradient startIntensity) {
        Screenshake screenshake = new Screenshake(0, time, startIntensity);
        screenshakes.add(screenshake);
        return screenshake;
    }

    public static class Screenshake {
        public FloatGradient intensity;
        public int startTicks;
        public int ticks;
        public int delay;

        public Screenshake(int delay, int startTicks, FloatGradient intensity) {
            this.delay = delay;
            this.startTicks = startTicks;
            this.intensity = intensity;
            this.ticks = startTicks;
        }

        protected void tick() {
            if (this.delay > 0) {
                --this.delay;
            } else {
                --this.ticks;
            }
        }

        public float getIntensity() {
            return ((Float)this.intensity.getValue(1.0f - (float)this.ticks / (float)this.startTicks)).floatValue();
        }

        public float getAdjustedIntensity() {
            return this.getIntensity() * (float)DatabankClientConfig.screenshakeMultiplier;
        }

        public void computeAngles(ViewportEvent.ComputeCameraAngles event) {
            float intensity = this.getAdjustedIntensity();
            float ySpeed = 20.0f;
            float xSpeed = ySpeed * 1.5f;
            float time = (float)(Blaze3D.getTime() * 360.0);
            float pitchOffset = (float)Math.cos(time * ySpeed) * intensity;
            float yawOffset = (float)Math.sin(time * xSpeed) * intensity;
            event.setPitch(event.getPitch() + pitchOffset);
            event.setYaw(event.getYaw() + yawOffset);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="databank", bus=EventBusSubscriber.Bus.GAME)
    protected static class GameEvents {
        protected GameEvents() {
        }

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Pre event) {
            for (Screenshake i2 : screenshakes) {
                i2.tick();
            }
            screenshakes.removeIf(i -> i.ticks <= 0);
        }

        @SubscribeEvent
        public static void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
            Screenshake strongestScreenshake = null;
            for (Screenshake i : screenshakes) {
                if (strongestScreenshake != null && !(strongestScreenshake.getIntensity() < i.getIntensity()) || i.delay > 0) continue;
                strongestScreenshake = i;
            }
            if (strongestScreenshake != null) {
                strongestScreenshake.computeAngles(event);
            }
        }
    }
}

