/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model;

import com.cmdpro.databank.DatabankExtraCodecs;
import com.cmdpro.databank.model.DatabankAnimation;
import com.cmdpro.databank.model.DatabankPartData;
import com.cmdpro.databank.model.DatabankPartDefinition;
import com.cmdpro.databank.model.ModelPose;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DatabankModel {
    public static final Codec<DatabankModel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DatabankPartDefinition.CODEC.listOf().fieldOf("parts").forGetter(model -> model.parts), (App)Codec.unboundedMap((Codec)Codec.STRING, DatabankAnimation.CODEC).fieldOf("animations").forGetter(model -> model.animations), (App)DatabankExtraCodecs.VECTOR2I.fieldOf("textureSize").forGetter(model -> model.textureSize)).apply((Applicative)instance, DatabankModel::new));
    public List<DatabankPartDefinition> parts;
    public Map<String, DatabankAnimation> animations;
    public Vector2i textureSize;
    public HashMap<String, DatabankPartData.DatabankBonePart> allBones = new HashMap();

    public DatabankModel(List<DatabankPartDefinition> parts, Map<String, DatabankAnimation> animations, Vector2i textureSize) {
        this.parts = parts;
        this.animations = animations;
        this.textureSize = textureSize;
        this.allBones = this.findBones(parts);
    }

    private HashMap<String, DatabankPartData.DatabankBonePart> findBones(List<DatabankPartDefinition> parts) {
        HashMap<String, DatabankPartData.DatabankBonePart> bones = new HashMap<String, DatabankPartData.DatabankBonePart>();
        for (DatabankPartDefinition i : parts) {
            DatabankPartData databankPartData = i.data;
            if (databankPartData instanceof DatabankPartData.DatabankBonePart) {
                DatabankPartData.DatabankBonePart bone = (DatabankPartData.DatabankBonePart)databankPartData;
                bones.put(bone.name, bone);
            }
            if (i.data.getChildren() == null) continue;
            bones.putAll(this.findBones(i.data.getChildren()));
        }
        return bones;
    }

    private void goThroughChildren(PartDefinition partDefinition, List<DatabankPartDefinition> definitions) {
        for (DatabankPartDefinition i : definitions) {
            PartDefinition part = partDefinition.addOrReplaceChild(i.data.name, i.createCubeListBuilder(), i.createPartPose());
            if (i.data.getChildren() == null) continue;
            this.goThroughChildren(part, i.data.getChildren());
        }
    }

    public ModelPose createModelPose() {
        HashMap<String, ModelPose.ModelPosePart> stringToPart = new HashMap<String, ModelPose.ModelPosePart>();
        ArrayList<ModelPose.ModelPosePart> children = new ArrayList<ModelPose.ModelPosePart>();
        for (DatabankPartDefinition i : this.parts) {
            Vector3f offset = new Vector3f((Vector3fc)i.data.getOffset());
            Vector3f rotation = new Vector3f((Vector3fc)i.data.getRotation()).mul(-1.0f, -1.0f, 1.0f);
            ModelPose.ModelPosePart part = new ModelPose.ModelPosePart(i, this.goThroughChildrenForModelPose(stringToPart, i), offset, rotation, new Vector3f((Vector3fc)i.data.getDimensions()));
            children.add(part);
            stringToPart.put(i.data.name, part);
        }
        return new ModelPose(children, stringToPart);
    }

    private List<ModelPose.ModelPosePart> goThroughChildrenForModelPose(HashMap<String, ModelPose.ModelPosePart> stringToPart, DatabankPartDefinition parent) {
        ArrayList<ModelPose.ModelPosePart> children = new ArrayList<ModelPose.ModelPosePart>();
        if (parent.data.getChildren() == null) {
            return children;
        }
        for (DatabankPartDefinition i : parent.data.getChildren()) {
            Vector3f offset = new Vector3f((Vector3fc)i.data.getOffset());
            Vector3f rotation = new Vector3f((Vector3fc)i.data.getRotation()).mul(-1.0f, -1.0f, 1.0f);
            ModelPose.ModelPosePart part = new ModelPose.ModelPosePart(i, this.goThroughChildrenForModelPose(stringToPart, i), offset, rotation, new Vector3f((Vector3fc)i.data.getDimensions()));
            children.add(part);
            stringToPart.put(i.data.name, part);
        }
        return children;
    }
}

