/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.music.conditions;

import com.cmdpro.databank.music.MusicCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityNearbyMusicCondition
extends MusicCondition {
    public ResourceKey<EntityType<?>> entityType;
    private EntityType<?> actualEntityType;

    public EntityNearbyMusicCondition(ResourceKey<EntityType<?>> entityType) {
        this.entityType = entityType;
    }

    @Override
    public boolean isPlaying() {
        for (Entity i : Minecraft.getInstance().level.entitiesForRendering()) {
            if (!i.getType().equals(this.getEntityType())) continue;
            return true;
        }
        return false;
    }

    public EntityType<?> getEntityType() {
        if (this.actualEntityType == null) {
            this.actualEntityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.entityType);
        }
        return this.actualEntityType;
    }

    public MusicCondition.Serializer getSerializer() {
        return EntityNearbyConditionSerializer.INSTANCE;
    }

    public static class EntityNearbyConditionSerializer
    extends MusicCondition.Serializer {
        public static final EntityNearbyConditionSerializer INSTANCE = new EntityNearbyConditionSerializer();
        public static final MapCodec<EntityNearbyMusicCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entity").forGetter(condition -> condition.entityType)).apply((Applicative)instance, EntityNearbyMusicCondition::new));

        public MapCodec<EntityNearbyMusicCondition> codec() {
            return CODEC;
        }
    }
}

