/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.networking.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record AddDimensionS2CPacket(ResourceKey<Level> key) implements Message
{
    public static final CustomPacketPayload.Type<AddDimensionS2CPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("add_dimension"));

    public static AddDimensionS2CPacket read(FriendlyByteBuf buf) {
        ResourceKey key = buf.readResourceKey(Registries.DIMENSION);
        return new AddDimensionS2CPacket((ResourceKey<Level>)key);
    }

    public static void write(FriendlyByteBuf buf, AddDimensionS2CPacket obj) {
        buf.writeResourceKey(obj.key);
    }

    public CustomPacketPayload.Type<AddDimensionS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext context) {
        ClientHandler.addDimension(this.key);
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void addDimension(ResourceKey<Level> key) {
            Minecraft.getInstance().player.connection.levels().add(key);
        }
    }
}

