/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.deepdarkdimdungeons.portal;

import com.breakinblocks.deepdarkdimdungeons.portal.DimDungeonsIntegration;
import com.breakinblocks.deepdarkdimdungeons.portal.PortalDestinationManager;
import com.breakinblocks.deepdarkdimdungeons.portal.SimplePortalDetector;
import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class DeepDarkCatalyst
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PORTAL_WIDTH = 20;
    private static final int PORTAL_HEIGHT = 6;
    private static final int GENERATION_PROGRESS_INTERVAL = 20;
    private static final int PARTICLE_INTERVAL = 4;
    private static final Map<String, GenerationInfo> activeGenerations = new HashMap<String, GenerationInfo>();

    public DeepDarkCatalyst(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockState clickedState = level.getBlockState(pos);
        if (!clickedState.is(Blocks.REINFORCED_DEEPSLATE)) {
            return InteractionResult.FAIL;
        }
        SimplePortalDetector.PortalFrame frame = SimplePortalDetector.detectPortalFrame(level, pos);
        if (frame != null && frame.width == 20 && frame.height == 6) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                DungeonGenData dungeonGenData = DimDungeonsIntegration.generateDungeon(serverLevel, pos);
                if (dungeonGenData == null) {
                    return InteractionResult.FAIL;
                }
                String generationKey = frame.bottomLeft.toShortString();
                GenerationInfo genInfo = new GenerationInfo(serverLevel, frame, dungeonGenData, frame.bottomLeft, null, player, context);
                activeGenerations.put(generationKey, genInfo);
                this.startGenerationMonitoring(generationKey);
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"deepdarkdimdungeons.portal.starting_generation"), true);
                }
                return InteractionResult.CONSUME;
            }
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"deepdarkdimdungeons.portal.generation_failed"), true);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    private void startGenerationMonitoring(String generationKey) {
        GenerationInfo genInfo = activeGenerations.get(generationKey);
        if (genInfo != null && !genInfo.monitoringActive) {
            genInfo.monitoringActive = true;
            Thread.ofVirtual().start(() -> {
                try {
                    Thread.sleep(1000L);
                    genInfo.level.getServer().execute(() -> this.monitorGeneration(generationKey));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    private void monitorGeneration(String generationKey) {
        GenerationInfo genInfo = activeGenerations.get(generationKey);
        if (genInfo == null) {
            return;
        }
        if (!genInfo.monitoringActive) {
            return;
        }
        try {
            if (this.isDungeonGenerationComplete(genInfo)) {
                genInfo.monitoringActive = false;
                this.completeGeneration(generationKey);
                return;
            }
            ++genInfo.buildStep;
            if (genInfo.buildStep % 20 == 0) {
                int seconds = genInfo.buildStep / 20;
                if (genInfo.player != null) {
                    genInfo.player.displayClientMessage((Component)Component.translatable((String)"deepdarkdimdungeons.portal.generating_progress", (Object[])new Object[]{seconds}), true);
                }
            }
            if (genInfo.buildStep % 4 == 0) {
                this.createGenerationParticles(genInfo);
            }
            Thread.ofVirtual().start(() -> {
                try {
                    Thread.sleep(1000L);
                    genInfo.level.getServer().execute(() -> this.monitorGeneration(generationKey));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error during generation monitoring for {}", (Object)generationKey, (Object)e);
            genInfo.monitoringActive = false;
            this.completeGeneration(generationKey);
        }
    }

    private ItemStack findCatalystInInventory(GenerationInfo genInfo) {
        if (genInfo.context != null && genInfo.context.getItemInHand().getItem() instanceof DeepDarkCatalyst) {
            return genInfo.context.getItemInHand();
        }
        for (int i = 0; i < genInfo.player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = genInfo.player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof DeepDarkCatalyst)) continue;
            return stack;
        }
        return null;
    }

    private void consumeCatalyst(GenerationInfo genInfo, ItemStack catalystToRemove) {
        if (genInfo.player.getAbilities().instabuild) {
            return;
        }
        if (genInfo.context != null && genInfo.context.getItemInHand() == catalystToRemove) {
            genInfo.context.getItemInHand().shrink(1);
        } else {
            for (int i = 0; i < genInfo.player.getInventory().getContainerSize(); ++i) {
                ItemStack stack = genInfo.player.getInventory().getItem(i);
                if (stack != catalystToRemove) continue;
                catalystToRemove.shrink(1);
                if (!catalystToRemove.isEmpty()) break;
                genInfo.player.getInventory().setItem(i, ItemStack.EMPTY);
                break;
            }
        }
    }

    private void activatePortal(GenerationInfo genInfo) {
        genInfo.frame.createPortal((Level)genInfo.level);
        BlockPos destination = DimDungeonsIntegration.getPortalDestination(genInfo.portalKey);
        PortalDestinationManager manager = PortalDestinationManager.get(genInfo.level);
        manager.setFrameDestination(genInfo.frame.bottomLeft, 20, 6, genInfo.frame.axis, destination);
        BlockPos soundPos = genInfo.frame.bottomLeft.offset(10, 3, 0);
        genInfo.level.playLocalSound((double)soundPos.getX() + 0.5, (double)soundPos.getY() + 0.5, (double)soundPos.getZ() + 0.5, SoundEvents.PORTAL_TRIGGER, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        DungeonGenData genData = genInfo.dungeonGenData;
        ItemPortalKey key = (ItemPortalKey)genInfo.portalKey.getItem();
        int entranceX = (int)key.getWarpX(genInfo.portalKey);
        int entranceZ = (int)key.getWarpZ(genInfo.portalKey);
        Direction dir = genInfo.frame.axis == Direction.Axis.X ? Direction.NORTH : Direction.EAST;
        genData.returnPoint = dir == Direction.EAST ? genData.returnPoint.offset(2, 0, 0) : genData.returnPoint.offset(0, 0, 2);
        DungeonUtils.reprogramExistingExitDoorway((Level)genInfo.level, (long)entranceX, (long)entranceZ, (DungeonGenData)genData, (Direction)dir);
    }

    private void completeGeneration(String generationKey) {
        GenerationInfo genInfo = activeGenerations.remove(generationKey);
        if (genInfo == null) {
            return;
        }
        try {
            if (genInfo.player == null) {
                return;
            }
            ItemStack catalystToRemove = this.findCatalystInInventory(genInfo);
            if (catalystToRemove == null || catalystToRemove.isEmpty()) {
                if (genInfo.player != null) {
                    genInfo.player.displayClientMessage((Component)Component.translatable((String)"deepdarkdimdungeons.portal.no_catalyst"), true);
                }
                return;
            }
            this.consumeCatalyst(genInfo, catalystToRemove);
            this.activatePortal(genInfo);
            if (genInfo.player != null) {
                MutableComponent message = genInfo.player.getAbilities().instabuild ? Component.translatable((String)"deepdarkdimdungeons.portal.complete") : Component.translatable((String)"deepdarkdimdungeons.portal.complete_consumed");
                genInfo.player.displayClientMessage((Component)message, true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error completing generation for {}", (Object)generationKey, (Object)e);
        }
    }

    private boolean isDungeonGenerationComplete(GenerationInfo genInfo) {
        try {
            Class<?> dungeonDataClass = Class.forName("com.catastrophe573.dimdungeons.dimension.DungeonData");
            Method getMethod = dungeonDataClass.getMethod("get", Level.class);
            Object dungeonData = getMethod.invoke(null, DungeonUtils.getDungeonWorld((MinecraftServer)genInfo.level.getServer()));
            if (dungeonData != null) {
                Method hasMoreRoomsToBuildMethod = dungeonDataClass.getMethod("hasMoreRoomsToBuild", new Class[0]);
                boolean hasMoreRooms = (Boolean)hasMoreRoomsToBuildMethod.invoke(dungeonData, new Object[0]);
                return !hasMoreRooms;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Failed to check dungeon generation status", (Throwable)e);
            return true;
        }
    }

    private void createGenerationParticles(GenerationInfo genInfo) {
        if (genInfo.level == null || genInfo.frame == null) {
            return;
        }
        Direction rightDir = genInfo.frame.axis == Direction.Axis.X ? Direction.EAST : Direction.NORTH;
        for (int x = 0; x < 20; ++x) {
            for (int y = 0; y < 6; ++y) {
                BlockPos particlePos = genInfo.frame.bottomLeft.relative(rightDir, x + 1).above(y + 1);
                genInfo.level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)particlePos.getX() + 0.5 + (genInfo.level.random.nextDouble() - 0.5) * 0.8, (double)particlePos.getY() + 0.5 + (genInfo.level.random.nextDouble() - 0.5) * 0.8, (double)particlePos.getZ() + 0.5 + (genInfo.level.random.nextDouble() - 0.5) * 0.8, 3, 0.2, 0.2, 0.2, 0.02);
                if (genInfo.level.random.nextInt(3) != 0) continue;
                genInfo.level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, (double)particlePos.getX() + 0.5 + (genInfo.level.random.nextDouble() - 0.5) * 0.6, (double)particlePos.getY() + 0.5 + (genInfo.level.random.nextDouble() - 0.5) * 0.6, (double)particlePos.getZ() + 0.5 + (genInfo.level.random.nextDouble() - 0.5) * 0.6, 2, 0.1, 0.1, 0.1, 0.05);
            }
        }
        if (genInfo.level.random.nextInt(2) == 0) {
            int side = genInfo.level.random.nextInt(4);
            BlockPos framePos = switch (side) {
                case 0 -> genInfo.frame.bottomLeft.relative(rightDir, genInfo.level.random.nextInt(22)).above(7);
                case 1 -> genInfo.frame.bottomLeft.relative(rightDir, genInfo.level.random.nextInt(22));
                case 2 -> genInfo.frame.bottomLeft.above(genInfo.level.random.nextInt(8));
                default -> genInfo.frame.bottomLeft.relative(rightDir, 21).above(genInfo.level.random.nextInt(8));
            };
            genInfo.level.sendParticles((ParticleOptions)ParticleTypes.SQUID_INK, (double)framePos.getX() + 0.5, (double)framePos.getY() + 0.5, (double)framePos.getZ() + 0.5, 1, 0.05, 0.05, 0.05, 0.01);
        }
    }

    protected static boolean actuallyReprogramGoldPortalBlocks(BlockPos bottomLeft, Level dim, DungeonGenData genData, Direction keyholeFacing) {
        for (int z = 0; z < 2; ++z) {
            for (int y = 0; y < 3; ++y) {
                BlockPos pos = bottomLeft.west(z).above(y);
                TileEntityGoldPortal te = (TileEntityGoldPortal)dim.getBlockEntity(pos);
                if (te == null) {
                    DimDungeons.logMessageWarn((String)("DIMDUNGEONS WARNING: why is there no exit portal here? (" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + ")"));
                    return false;
                }
                te.setDestination((double)genData.returnPoint.getX(), (double)genData.returnPoint.getY(), (double)genData.returnPoint.getZ(), genData.returnDimension, keyholeFacing);
                DimDungeons.logMessageInfo((String)("DIMDUNGEONS INFO: Reprogrammed exit door at (" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + ") in dim " + dim.dimension().location().getPath()));
            }
        }
        return true;
    }

    private static class GenerationInfo {
        public final ServerLevel level;
        public final SimplePortalDetector.PortalFrame frame;
        public final ItemStack portalKey;
        public final DungeonGenData dungeonGenData;
        public final BlockPos framePos;
        public final BlockState originalBlock;
        public final Player player;
        public final UseOnContext context;
        public int buildStep = 0;
        public final long startTime;
        public boolean monitoringActive = false;

        public GenerationInfo(ServerLevel level, SimplePortalDetector.PortalFrame frame, DungeonGenData dungeonGenData, BlockPos framePos, BlockState originalBlock, Player player, UseOnContext context) {
            this.level = level;
            this.frame = frame;
            this.portalKey = dungeonGenData.keyItem;
            this.dungeonGenData = dungeonGenData;
            this.framePos = framePos;
            this.originalBlock = originalBlock;
            this.player = player;
            this.context = context;
            this.startTime = System.currentTimeMillis();
        }
    }
}

