/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemBlankTeleporterKey
extends BaseItemKey {
    public static final String REG_NAME = "item_blank_teleporter_key";

    public ItemBlankTeleporterKey() {
        super(new Item.Properties().rarity(Rarity.COMMON).stacksTo(1).component(DimDungeons.DUNGEON_KEY_DATA.get(), (Object)new DungeonKeyDataComponentRecord(false, false, -1L, -1L, 0, 0, 0, 0, String.valueOf((Object)DungeonDesigner.DungeonType.valueOf(String.valueOf((Object)DungeonDesigner.DungeonType.BASIC))))));
    }

    @Override
    public void performActivationRitual(Player player, ItemStack itemstack, Level worldIn, BlockPos pos) {
        worldIn.playSound((Player)null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.createActivationParticleEffects(worldIn, pos);
        this.createActivationParticleEffectsForTeleporterKey(worldIn, pos, itemstack);
        if (!worldIn.isClientSide) {
            int slot = player.getInventory().findSlotMatchingItem(itemstack);
            itemstack.shrink(1);
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
            this.activateKeyForNewTeleporterHub(worldIn.getServer(), newkey);
            if (!player.getInventory().add(slot, newkey) && !player.addItem(newkey)) {
                player.drop(newkey, false);
            }
        }
    }

    public void createActivationParticleEffectsForTeleporterKey(Level worldIn, BlockPos pos, ItemStack itemstack) {
        RandomSource random = worldIn.getRandom();
        for (int i = 0; i < 24; ++i) {
            double d0 = (float)pos.getX() + 0.5f;
            double d1 = (float)pos.getY() + 0.8f;
            double d2 = (float)pos.getZ() + 0.5f;
            double xspeed = (double)random.nextFloat() * 0.08 * (double)(random.nextBoolean() ? 1 : -1);
            double yspeed = (double)random.nextFloat() * 0.45;
            double zspeed = (double)random.nextFloat() * 0.08 * (double)(random.nextBoolean() ? 1 : -1);
            worldIn.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemstack), d0, d1, d2, xspeed, yspeed, zspeed);
        }
    }
}

