/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.nonliving;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.client.nonliving.model.NLGeoLayerJSBuilder;
import net.liopyu.entityjs.client.nonliving.model.NonLivingEntityModel;
import net.liopyu.entityjs.entities.nonliving.entityjs.IAnimatableJSNL;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class KubeJSNLEntityRenderer<T extends Entity>
extends GeoEntityRenderer<T> {
    private final BaseEntityBuilder<T> builder;

    public KubeJSNLEntityRenderer(EntityRendererProvider.Context renderManager, BaseEntityBuilder<T> builder) {
        super(renderManager, new NonLivingEntityModel<T>(builder));
        Object layerPart;
        this.builder = builder;
        this.scaleHeight = this.getScaleHeight();
        this.scaleWidth = this.getScaleWidth();
        for (NLGeoLayerJSBuilder<T> geoBuilder : builder.layerList) {
            layerPart = geoBuilder.build(this, builder);
            this.addRenderLayer((GeoRenderLayer)layerPart);
        }
        for (NLGeoLayerJSBuilder<T> geoBuilder : builder.glowingLayerList) {
            layerPart = geoBuilder.buildGlowing(this, builder);
            this.addRenderLayer((GeoRenderLayer)layerPart);
        }
    }

    public String entityName() {
        return this.animatable.getType().toString();
    }

    public float getScaleHeight() {
        return this.builder.scaleHeight;
    }

    public float getScaleWidth() {
        return this.builder.scaleWidth;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (this.builder.scaleModelForRender != null && this.animatable != null) {
            ContextUtils.ScaleModelRenderContextNL<T> context = new ContextUtils.ScaleModelRenderContextNL<T>(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.builder.scaleModelForRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: scaleModelForRender.");
            super.scaleModelForRender(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        } else {
            super.scaleModelForRender(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return (ResourceLocation)this.builder.textureResource.apply(entity);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        if (this.builder.renderTypeFunction != null) {
            try {
                return this.builder.renderTypeFunction.apply(animatable);
            }
            catch (RuntimeException e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in renderTypeFunction.", e);
            }
        }
        return switch (((IAnimatableJSNL)animatable).getBuilder().renderType) {
            default -> throw new MatchException(null, null);
            case BaseEntityBuilder.RenderType.SOLID -> RenderType.entitySolid((ResourceLocation)texture);
            case BaseEntityBuilder.RenderType.CUTOUT -> RenderType.entityCutout((ResourceLocation)texture);
            case BaseEntityBuilder.RenderType.TRANSLUCENT -> RenderType.entityTranslucent((ResourceLocation)texture);
        };
    }

    public void render(T animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (this.builder.facesTrajectory) {
            Vec3 velocity = animatable.getDeltaMovement();
            double velX = velocity.x();
            double velY = velocity.y();
            double velZ = velocity.z();
            float yaw = (float)(Math.atan2(velZ, velX) * 57.29577951308232 - 90.0);
            float pitch = (float)(Math.atan2(velY, Math.sqrt(velX * velX + velZ * velZ)) * 57.29577951308232);
            poseStack.mulPose(Axis.YP.rotationDegrees(-yaw));
            poseStack.mulPose(Axis.XP.rotationDegrees(-pitch));
        }
        if (this.builder.render != null && this.animatable != null) {
            ContextUtils.NLRenderContext<T> context = new ContextUtils.NLRenderContext<T>(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render.");
            super.render(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        } else {
            super.render(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }
}

