/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.FMLPaths;

public class BetterUI {
    private static List<Map.Entry<String, Integer>> entries;

    public static void loadConfig(String modId) {
        Gson gson = new Gson();
        Path configDir = FMLPaths.CONFIGDIR.get().resolve(modId);
        Path configPath = configDir.resolve("config.json");
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (!Files.exists(configPath, new LinkOption[0])) {
                System.out.println("Config file does not exist, creating a default one.");
                BetterUI.createDefaultConfig(configPath);
            }
            String content = Files.readString(configPath);
            List jsonEntries = (List)gson.fromJson(content, new TypeToken<List<Map<String, Object>>>(){}.getType());
            entries = jsonEntries.stream().map(entry -> Map.entry((String)entry.get("key"), ((Number)entry.get("value")).intValue())).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            entries = new ArrayList<Map.Entry<String, Integer>>();
        }
    }

    private static void createDefaultConfig(Path configPath) throws IOException {
        String defaultContent = "[{\"key\":\"minecraft:village_plains\",\"value\":1}]";
        Files.writeString(configPath, (CharSequence)defaultContent, new OpenOption[0]);
    }

    public static List<Map.Entry<String, Integer>> getEntries() {
        return entries;
    }
}

