/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.other;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.util.LocalPlayerUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.input.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendMessageAction
extends Action {
    public SendMessageAction() {
        super("sendmessage");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null) {
            value = StringUtils.convertFormatCodes((String)value, (String)"\u00a7", (String)"&");
            if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
                if (value.startsWith("/")) {
                    value = value.substring(1);
                    LocalPlayerUtils.sendPlayerCommand(Minecraft.getInstance().player, value);
                } else {
                    LocalPlayerUtils.sendPlayerChatMessage(Minecraft.getInstance().player, value);
                }
            }
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.translatable((String)"fancymenu.actions.sendmessage");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.sendmessage.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.translatable((String)"fancymenu.actions.sendmessage.desc.value");
    }

    @Override
    public String getValueExample() {
        return "This is an example chat message!";
    }
}

