/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.checkbox;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.customization.element.elements.checkbox.CheckboxElement;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CheckboxStatesHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CHECKBOX_STATE_FILE = new File(GameDirectoryUtils.getGameDirectory(), "checkbox_states.json");
    private static final Map<String, Boolean> STATES_MAP = new HashMap<String, Boolean>();
    private static boolean loaded = false;

    private static void loadFromFile() {
        if (loaded) {
            return;
        }
        try {
            if (CHECKBOX_STATE_FILE.exists()) {
                try (FileReader reader = new FileReader(CHECKBOX_STATE_FILE);){
                    Type mapType = new TypeToken<Map<String, Boolean>>(){}.getType();
                    Map loadedMap = (Map)GSON.fromJson((Reader)reader, mapType);
                    if (loadedMap != null) {
                        STATES_MAP.clear();
                        STATES_MAP.putAll(loadedMap);
                    }
                }
            }
            loaded = true;
        }
        catch (IOException e) {
            LOGGER.error("[FANCYMENU] Failed to load checkbox states from file!", (Throwable)e);
            loaded = true;
        }
    }

    private static void saveToFile() {
        try {
            File parentDir = CHECKBOX_STATE_FILE.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (FileWriter writer = new FileWriter(CHECKBOX_STATE_FILE);){
                GSON.toJson(STATES_MAP, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("[FANCYMENU] Failed to save checkbox states to file!", (Throwable)e);
        }
    }

    public static void setForCheckboxElement(@NotNull CheckboxElement element, boolean state) {
        CheckboxStatesHandler.loadFromFile();
        STATES_MAP.put(element.getInstanceIdentifier(), state);
        CheckboxStatesHandler.saveToFile();
    }

    public static boolean getForCheckboxElement(@NotNull CheckboxElement element) {
        CheckboxStatesHandler.loadFromFile();
        String id = element.getInstanceIdentifier();
        if (!STATES_MAP.containsKey(id)) {
            return false;
        }
        return STATES_MAP.get(id);
    }
}

