/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnCloseScreenListener
extends AbstractListener {
    @Nullable
    private String lastScreenIdentifier;

    public OnCloseScreenListener() {
        super("screen_close");
    }

    public void onScreenClosed(@NotNull Screen screen) {
        this.lastScreenIdentifier = ScreenIdentifierHandler.getIdentifierOfScreen(screen);
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("screen_identifier", () -> this.lastScreenIdentifier != null ? this.lastScreenIdentifier : "ERROR"));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_close_screen");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_close_screen.desc", new String[0]));
    }
}

