/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnWeatherChangedListener
extends AbstractListener {
    @Nullable
    private String cachedWeatherType;
    @Nullable
    private String cachedWeatherCanSnow;
    @Nullable
    private String cachedWeatherCanRain;

    public OnWeatherChangedListener() {
        super("weather_changed");
    }

    public void onWeatherChanged(@NotNull String weatherType, boolean canSnow, boolean canRain) {
        this.cachedWeatherType = weatherType;
        this.cachedWeatherCanSnow = Boolean.toString(canSnow);
        this.cachedWeatherCanRain = Boolean.toString(canRain);
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("weather_type", () -> this.cachedWeatherType != null ? this.cachedWeatherType : "clear"));
        list.add(new AbstractListener.CustomVariable("weather_can_snow", () -> this.cachedWeatherCanSnow != null ? this.cachedWeatherCanSnow : "false"));
        list.add(new AbstractListener.CustomVariable("weather_can_rain", () -> this.cachedWeatherCanRain != null ? this.cachedWeatherCanRain : "false"));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_weather_changed");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_weather_changed.desc", new String[0]));
    }
}

