/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleToast
implements Toast {
    protected static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/tutorial");
    public static final int PROGRESS_BAR_WIDTH = 154;
    public static final int PROGRESS_BAR_HEIGHT = 1;
    public static final int PROGRESS_BAR_X = 3;
    public static final int PROGRESS_BAR_Y = 28;
    @NotNull
    protected final Icon icon;
    @NotNull
    protected final Component title;
    @Nullable
    protected final Component message;
    protected Toast.Visibility visibility = Toast.Visibility.SHOW;
    protected long lastProgressTime;
    protected float lastProgress;
    protected float progress;
    protected final boolean progressable;
    @Nullable
    protected ResourceSupplier<ITexture> customBackground;
    int width = 160;
    int height = 32;

    public SimpleToast(@NotNull Icon icon, @NotNull Component title, @Nullable Component message, boolean progressable) {
        this.icon = icon;
        this.title = title;
        this.message = message;
        this.progressable = progressable;
    }

    @NotNull
    public Toast.Visibility render(@NotNull GuiGraphics graphics, @NotNull ToastComponent toastComponent, long progressTime) {
        ResourceLocation customBack = this.getCustomBackground();
        if (customBack == null) {
            graphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        } else {
            graphics.blit(customBack, 0, 0, 0.0f, 0.0f, this.width(), this.height(), this.width(), this.height());
        }
        this.icon.render(graphics, 6, 6);
        if (this.message == null) {
            graphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 12, -11534256, false);
        } else {
            graphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 7, -11534256, false);
            graphics.drawString(toastComponent.getMinecraft().font, this.message, 30, 18, -16777216, false);
        }
        if (this.progressable) {
            graphics.fill(3, 28, 157, 29, -1);
            float clampProgress = Mth.clampedLerp((float)this.lastProgress, (float)this.progress, (float)((float)(progressTime - this.lastProgressTime) / 100.0f));
            int progressColor = this.progress >= this.lastProgress ? -16755456 : -11206656;
            graphics.fill(3, 28, (int)(3.0f + 154.0f * clampProgress), 29, progressColor);
            this.lastProgress = clampProgress;
            this.lastProgressTime = progressTime;
        }
        return this.visibility;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    @NotNull
    public SimpleToast setHeight(int height) {
        this.height = height;
        return this;
    }

    @NotNull
    public SimpleToast setWidth(int width) {
        this.width = width;
        return this;
    }

    @Nullable
    protected ResourceLocation getCustomBackground() {
        ITexture tex;
        if (this.customBackground != null && (tex = this.customBackground.get()) != null) {
            return tex.getResourceLocation();
        }
        return null;
    }

    @NotNull
    public SimpleToast setCustomBackground(@Nullable ResourceSupplier<ITexture> texture) {
        this.customBackground = texture;
        return this;
    }

    public void hide() {
        this.visibility = Toast.Visibility.HIDE;
    }

    public void updateProgress(float progress) {
        this.progress = progress;
    }

    public static class Icon {
        protected ResourceLocation location;
        protected ResourceSupplier<ITexture> supplier;

        public Icon(@NotNull ResourceLocation textureLocation) {
            this.location = textureLocation;
        }

        public Icon(@NotNull ResourceSupplier<ITexture> textureSupplier) {
            this.supplier = textureSupplier;
        }

        public void render(GuiGraphics graphics, int x, int y) {
            ResourceLocation icon = this.getIcon();
            if (icon != null) {
                RenderSystem.enableBlend();
                graphics.blit(icon, x, y, 0.0f, 0.0f, 20, 20, 20, 20);
            }
        }

        @Nullable
        protected ResourceLocation getIcon() {
            ITexture tex;
            if (this.location != null) {
                return this.location;
            }
            if (this.supplier != null && (tex = this.supplier.get()) != null) {
                return tex.getResourceLocation();
            }
            return null;
        }
    }
}

