/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.boss_screen;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.client.BossRenderUtil;
import com.finderfeed.fdbosses.client.boss_screen.screen_definitions.BossInfo;
import com.finderfeed.fdbosses.client.boss_screen.screen_definitions.BossScreenOptions;
import com.finderfeed.fdbosses.client.boss_screen.widget.BossAbilitesWidget;
import com.finderfeed.fdbosses.client.boss_screen.widget.BossDetailsWidget;
import com.finderfeed.fdbosses.client.boss_screen.widget.DidntReadSkillWarningWidget;
import com.finderfeed.fdbosses.client.boss_screen.widget.FDButtonWithTexture;
import com.finderfeed.fdbosses.client.boss_screen.widget.FDSkillButton;
import com.finderfeed.fdbosses.client.boss_screen.widget.QliphothAwakeningSocialsWidget;
import com.finderfeed.fdbosses.client.boss_screen.widget.SkillInfoWidget;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerEntity;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerStartFight;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.systems.simple_screen.FDScrollableWidget;
import com.finderfeed.fdlib.systems.simple_screen.FDWidget;
import com.finderfeed.fdlib.systems.simple_screen.SimpleFDScreen;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.FDButton;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.TextBlockWidget;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.util.FDButtonTextures;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.util.WidgetTexture;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector2f;

public abstract class BaseBossScreen
extends SimpleFDScreen {
    public static final int DEFAULT_TEXT_COLOR = 0x55CCFF;
    public static boolean wasSkillRead = false;
    private static int OPEN_TIME = 9;
    private boolean skillOpened = false;
    private int openTicker = 0;
    protected SkillInfoWidget skillInfoWidget;
    protected TextBlockWidget skillInfoText;
    protected BossScreenOptions options;
    protected BossDetailsWidget bossDetailsWidget;
    protected BossAbilitesWidget bossAbilitesWidget;
    protected FDButton skillStatsButton;
    protected FDButton skillInfoButton;
    protected float bossMenuXStart = 0.0f;
    protected QliphothAwakeningSocialsWidget socialsWidget;
    private DidntReadSkillWarningWidget didntReadSkillWarningWidget;
    private int moveThings = 0;
    private int bossSpawnerId;
    private List<Item> possibleDrops;

    public BaseBossScreen(int bossSpawnerId, List<Item> possibleDrops, BossScreenOptions options) {
        this.possibleDrops = possibleDrops;
        this.options = options;
        this.bossSpawnerId = bossSpawnerId;
    }

    protected void init() {
        super.init();
        this.moveThings = 0;
        this.skillOpened = false;
        OPEN_TIME = 11;
        this.openTicker = 0;
        Window window = Minecraft.getInstance().getWindow();
        this.initBossDetails();
        this.initSkillInfoWidget();
        this.initAbilitiesWidget();
        this.initDidntReadSkillWarningWidget();
        FDButton startFightButton = new FDButton((Screen)this, 6.0f, 6.0f, 110.0f, 24.0f).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/medium_button.png")), new WidgetTexture(FDBosses.location("textures/gui/medium_button_selected.png"), 1.0f, 1.0f))).setSound(BossSounds.BUTTON_CLICK.get()).setText((Component)Component.translatable((String)"fdbosses.word.start_fight").withStyle(Style.EMPTY.withColor(this.getBaseStringColor())), 110, 1.0f, true, 0.0f, 1.0f).setOnClickAction((fdWidget1, v2, v11, i1) -> {
            if (wasSkillRead) {
                Level level = FDClientHelpers.getClientLevel();
                Entity patt0$temp = level.getEntity(this.bossSpawnerId);
                if (patt0$temp instanceof BossSpawnerEntity) {
                    BossSpawnerEntity bossSpawner = (BossSpawnerEntity)patt0$temp;
                    PacketDistributor.sendToServer((CustomPacketPayload)new BossSpawnerStartFight(this.bossSpawnerId), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                this.didntReadSkillWarningWidget.setActive(true);
            }
            return true;
        });
        this.addRenderableWidget((GuiEventListener)startFightButton);
        this.initTLDRButton();
        this.initSocialsButton();
    }

    private void initDidntReadSkillWarningWidget() {
        DidntReadSkillWarningWidget didntReadSkillWarningWidget;
        Vector2f anchor = this.getAnchor(0.5f, 0.5f);
        this.didntReadSkillWarningWidget = didntReadSkillWarningWidget = new DidntReadSkillWarningWidget(this, anchor.x - 150.0f, anchor.y - 40.0f, 300.0f, 80.0f);
        FDButton yes = new FDButton((Screen)this, 20.0f, didntReadSkillWarningWidget.getHeight() - 25.0f, 110.0f, 24.0f).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/medium_button.png")), new WidgetTexture(FDBosses.location("textures/gui/medium_button_selected.png"), 1.0f, 1.0f))).setSound(BossSounds.BUTTON_CLICK.get()).setText((Component)Component.translatable((String)"fdbosses.word.yes").withStyle(Style.EMPTY.withColor(this.getBaseStringColor())), 110, 1.0f, true, 0.0f, 1.0f).setOnClickAction((fdWidget1, v2, v11, i1) -> {
            Level level = FDClientHelpers.getClientLevel();
            Entity patt0$temp = level.getEntity(this.bossSpawnerId);
            if (patt0$temp instanceof BossSpawnerEntity) {
                BossSpawnerEntity bossSpawner = (BossSpawnerEntity)patt0$temp;
                PacketDistributor.sendToServer((CustomPacketPayload)new BossSpawnerStartFight(this.bossSpawnerId), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        });
        FDButton no = new FDButton((Screen)this, didntReadSkillWarningWidget.getWidth() - 120.0f, didntReadSkillWarningWidget.getHeight() - 25.0f, 110.0f, 24.0f).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/medium_button.png")), new WidgetTexture(FDBosses.location("textures/gui/medium_button_selected.png"), 1.0f, 1.0f))).setSound(BossSounds.BUTTON_CLICK.get()).setText((Component)Component.translatable((String)"fdbosses.word.no").withStyle(Style.EMPTY.withColor(this.getBaseStringColor())), 110, 1.0f, true, 0.0f, 1.0f).setOnClickAction((fdWidget1, v2, v11, i1) -> {
            this.didntReadSkillWarningWidget.setActive(false);
            return true;
        });
        this.didntReadSkillWarningWidget.setActive(false);
        didntReadSkillWarningWidget.addChild("yes", (FDWidget)yes);
        didntReadSkillWarningWidget.addChild("no", (FDWidget)no);
        this.addRenderableWidget((GuiEventListener)didntReadSkillWarningWidget);
    }

    private void initBossDetails() {
        Vector2f anchor = this.getAnchor(1.0f, 0.0f);
        float bossInfoWidth = 237.0f;
        float bossInfoHeight = 130.0f;
        float bossInfoYs = 0.0f;
        BossDetailsWidget widget = new BossDetailsWidget((Screen)this, anchor.x, bossInfoYs, bossInfoWidth, bossInfoHeight);
        widget.setBossInfo(this.options.getEntityType().getDescription(), this.getBaseStringColor());
        this.bossMenuXStart = anchor.x - bossInfoWidth;
        TextBlockWidget bossDescription = new TextBlockWidget((Screen)this, 18.0f, 60.0f, 195.0f, 52.0f);
        bossDescription.setText(this.options.getBossDescription(), 1.0f, this.getBaseStringColor(), true);
        widget.addChild("bossDescription", (FDWidget)bossDescription);
        this.addRenderableWidget((GuiEventListener)widget);
        this.bossDetailsWidget = widget;
    }

    private void initSkillInfoWidget() {
        FDButton fdButtonInfo;
        Vector2f anchor = this.getAnchor(1.0f, 1.0f);
        SkillInfoWidget widget = new SkillInfoWidget((Screen)this, -200.0f, 2.0f, 200.0f, anchor.y - 4.0f, (Component)Component.literal((String)"TTT"), this.getBaseStringColor());
        FDButton fdButtonStats = new FDButton((Screen)this, 108.0f, 79.0f, 73.0f, 24.0f).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/small_button.png")), new WidgetTexture(FDBosses.location("textures/gui/small_button_selected.png"), 1.0f, 1.0f))).setSound(BossSounds.BUTTON_CLICK.get()).setText((Component)Component.translatable((String)"fdbosses.word.stats").withStyle(Style.EMPTY.withColor(this.getBaseStringColor())), 61, 1.0f, true, 0.0f, 1.0f);
        this.skillInfoButton = fdButtonInfo = new FDButton((Screen)this, 30.0f, 79.0f, 73.0f, 24.0f).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/small_button.png")), new WidgetTexture(FDBosses.location("textures/gui/small_button_selected.png"), 1.0f, 1.0f))).setSound(BossSounds.BUTTON_CLICK.get()).setText((Component)Component.translatable((String)"fdbosses.word.info").withStyle(Style.EMPTY.withColor(this.getBaseStringColor())), 61, 1.0f, true, 0.0f, 1.0f);
        this.skillStatsButton = fdButtonStats;
        TextBlockWidget textBlockWidget = new TextBlockWidget((Screen)this, 30.0f, 107.0f, 151.0f, widget.getHeight() - 130.0f);
        widget.addChild("text", (FDWidget)textBlockWidget);
        widget.addChild("statsButton", (FDWidget)fdButtonStats);
        widget.addChild("infoButton", (FDWidget)fdButtonInfo);
        this.skillInfoWidget = widget;
        this.skillInfoText = textBlockWidget;
        this.addRenderableWidget((GuiEventListener)widget);
    }

    private void initAbilitiesWidget() {
        Vector2f anchorEnd = this.getAnchor(1.0f, 1.0f);
        BossAbilitesWidget bossAbilitesWidget = new BossAbilitesWidget((Screen)this, anchorEnd.x - 237.0f, anchorEnd.y, this.getBaseStringColor());
        List<BossInfo> skills = this.options.getSkills();
        this.initAbilitiesWidgetModeChangeButtons(bossAbilitesWidget);
        this.initAbilitiesWidgetInfoButtons(bossAbilitesWidget.bossAbilitiesButtonContainer, skills, false);
        this.addRenderableWidget((GuiEventListener)bossAbilitesWidget);
        this.bossAbilitesWidget = bossAbilitesWidget;
    }

    private void initAbilitiesWidgetModeChangeButtons(BossAbilitesWidget bossAbilitesWidget) {
        FDButton fdButtonSkills = new FDButton((Screen)this, 34.0f, 1.0f, 73.0f, 24.0f).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/small_button.png")), new WidgetTexture(FDBosses.location("textures/gui/small_button_selected.png"), 1.0f, 1.0f))).setSound(BossSounds.BUTTON_CLICK.get()).setText((Component)Component.translatable((String)"fdbosses.word.abilities").withStyle(Style.EMPTY.withColor(this.getBaseStringColor())), 73, 1.0f, true, 0.0f, 1.0f).setOnClickAction((fdWidget, v, v1, i) -> {
            this.resetAbilities(this.options.getSkills(), false);
            return true;
        });
        FDButton fdButtonDrops = new FDButton((Screen)this, 124.0f, 1.0f, 73.0f, 24.0f).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/small_button.png")), new WidgetTexture(FDBosses.location("textures/gui/small_button_selected.png"), 1.0f, 1.0f))).setSound(BossSounds.BUTTON_CLICK.get()).setText((Component)Component.translatable((String)"fdbosses.word.drops").withStyle(Style.EMPTY.withColor(this.getBaseStringColor())), 73, 1.0f, true, 0.0f, 1.0f).setOnClickAction((fdWidget, v, v1, i) -> {
            this.resetAbilities(this.createPossibleDropsBossInfos(), false);
            return true;
        });
        bossAbilitesWidget.addChild("openSkills", (FDWidget)fdButtonSkills);
        bossAbilitesWidget.addChild("openDrops", (FDWidget)fdButtonDrops);
    }

    private List<BossInfo> createPossibleDropsBossInfos() {
        ArrayList<BossInfo> bossInfos = new ArrayList<BossInfo>();
        EntityType<?> entityType = this.options.getEntityType();
        ResourceLocation typeKey = BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
        String keyString = typeKey.toString().replace(":", ".");
        for (Item item : this.possibleDrops) {
            ItemStack itemStack = item.getDefaultInstance();
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
            String itemId = key.toString().replace(":", ".");
            String infoString = "fdbosses.boss_drop." + keyString + "." + itemId + ".info";
            String statsString = "fdbosses.boss_drop." + keyString + "." + itemId + ".stats";
            MutableComponent stats = null;
            Object info = this.hasTranslatableFor(infoString) ? Component.translatable((String)infoString) : itemStack.getHoverName();
            if (this.hasTranslatableFor(statsString)) {
                stats = Component.translatable((String)statsString);
            }
            BossInfo bossInfo = new BossInfo(itemStack, (Component)stats, (Component)info);
            bossInfos.add(bossInfo);
        }
        return bossInfos;
    }

    private boolean hasTranslatableFor(String id) {
        MutableComponent component = Component.translatable((String)id);
        String translated = component.getString();
        return !translated.equals(id);
    }

    protected void resetAbilities(List<BossInfo> bossInfos, boolean malkuthShuffle) {
        this.bossAbilitesWidget.bossAbilitiesButtonContainer.setCurrentScroll(0.0f);
        this.bossAbilitesWidget.bossAbilitiesButtonContainer.removeAllChildren();
        this.initAbilitiesWidgetInfoButtons(this.bossAbilitesWidget.bossAbilitiesButtonContainer, bossInfos, malkuthShuffle);
    }

    private void initSocialsButton() {
        Vector2f anchor = this.getAnchor(0.0f, 1.0f);
        Vector2f anchor2 = this.getAnchor(0.5f, 0.5f);
        float x = anchor2.x;
        float y = anchor2.y;
        this.socialsWidget = new QliphothAwakeningSocialsWidget((Screen)this, x - 60.0f, y - 35.0f, 120.0f, 70.0f);
        FDButton button = new FDButtonWithTexture((Screen)this, anchor.x + 4.0f, anchor.y - 72.0f, 32.0f, 32.0f, FDBosses.location("textures/gui/link.png")).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/ability_button_unselected.png"), 0.0f, 0.0f), new WidgetTexture(FDBosses.location("textures/gui/ability_button_selected.png"), 1.0f, 1.0f))).setSound(BossSounds.BUTTON_CLICK.get()).setOnHoverAction((fdWidget, guiGraphics, v, v1, v2) -> {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 100.0f);
            BossRenderUtil.renderBossScreenTooltip(guiGraphics, (Component)Component.translatable((String)"fdbosses.word.socials"), v, v1, 200.0f, this.getBaseStringColor(), 1.0f);
            poseStack.popPose();
        }).setOnClickAction((fdWidget, v, v1, i) -> {
            this.socialsWidget.setActive(true);
            return true;
        });
        this.addRenderableWidget((GuiEventListener)button);
        this.socialsWidget.setActive(false);
        this.addWidget((GuiEventListener)this.socialsWidget);
    }

    private void initTLDRButton() {
        Vector2f anchor = this.getAnchor(0.0f, 1.0f);
        BossInfo bossInfo = new BossInfo(ResourceLocation.parse((String)"minecraft:textures/item/book.png"), (Component)Component.translatable((String)"fdbosses.word.short_description"), null, this.options.getTLDRComponent());
        FDButton skill = new FDSkillButton((Screen)this, anchor.x + 4.0f, anchor.y - 36.0f, 32.0f, 32.0f, bossInfo).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/ability_button_unselected.png"), 0.0f, 0.0f), new WidgetTexture(FDBosses.location("textures/gui/ability_button_selected.png"), 1.0f, 1.0f))).setOnHoverAction((fdWidget, guiGraphics, v, v1, v2) -> {
            if (!this.skillOpened) {
                PoseStack matrices = guiGraphics.pose();
                matrices.pushPose();
                matrices.translate(0.0f, 0.0f, 100.0f);
                BossRenderUtil.renderBossScreenTooltip(guiGraphics, (Component)Component.translatable((String)"fdbosses.word.tldr"), v, v1, 200.0f, this.getBaseStringColor(), 1.0f);
                matrices.popPose();
            }
        }).setSound(BossSounds.BUTTON_CLICK.get()).setOnClickAction((fdWidget, mx, my, button) -> {
            if (button != 0) {
                return false;
            }
            wasSkillRead = true;
            this.openSkillInfo(bossInfo, true);
            return true;
        });
        this.addRenderableWidget((GuiEventListener)skill);
    }

    private void initAbilitiesWidgetInfoButtons(FDScrollableWidget bossAbilitesWidget, List<BossInfo> bossInfos, boolean malkuthShuffle) {
        int i;
        float offsx = 5.0f;
        float offsy = 4.0f;
        ArrayList<BossInfo> bossInfos2 = new ArrayList<BossInfo>(bossInfos);
        Random random = new Random();
        if (malkuthShuffle && bossInfos2.size() > 1) {
            for (i = 0; i < bossInfos2.size() * 2; ++i) {
                int id2;
                int id1 = random.nextInt(bossInfos2.size());
                BossInfo info1 = (BossInfo)bossInfos2.get(id1);
                while ((id2 = random.nextInt(bossInfos2.size())) == id1) {
                }
                BossInfo info2 = (BossInfo)bossInfos2.get(id2);
                bossInfos2.set(id1, info2);
                bossInfos2.set(id2, info1);
            }
        }
        for (i = 0; i < bossInfos.size(); ++i) {
            BossInfo bossSkill = bossInfos.get(i);
            BossInfo skillToOpen = (BossInfo)bossInfos2.get(i);
            float x = offsx + (float)(i % 5 * 39);
            float y = offsy + (float)(i / 5 * 35);
            FDButton skill = new FDSkillButton((Screen)this, x, y, 32.0f, 32.0f, bossSkill).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/ability_button_unselected.png"), 0.0f, 0.0f), new WidgetTexture(FDBosses.location("textures/gui/ability_button_selected.png"), 1.0f, 1.0f))).setOnHoverAction((fdWidget, guiGraphics, v, v1, v2) -> {
                if (!this.skillOpened) {
                    PoseStack matrices = guiGraphics.pose();
                    matrices.pushPose();
                    matrices.translate(0.0f, 0.0f, 100.0f);
                    BossRenderUtil.renderBossScreenTooltip(guiGraphics, (Component)Component.translatable((String)"fdbosses.skills.skill_button"), v, v1, 200.0f, this.getBaseStringColor(), 1.0f, this.bossAbilitesWidget.bossAbilitiesButtonContainer.getX(), this.bossAbilitesWidget.bossAbilitiesButtonContainer.getY(), this.bossAbilitesWidget.bossAbilitiesButtonContainer.getX() + this.bossAbilitesWidget.bossAbilitiesButtonContainer.getWidth(), this.bossAbilitesWidget.bossAbilitiesButtonContainer.getY() + this.bossAbilitesWidget.bossAbilitiesButtonContainer.getHeight());
                    matrices.popPose();
                }
            }).setSound(BossSounds.BUTTON_CLICK.get()).setOnClickAction((fdWidget, mx, my, button) -> {
                if (button != 0) {
                    return false;
                }
                wasSkillRead = true;
                this.openSkillInfo(skillToOpen, true);
                return true;
            });
            bossAbilitesWidget.addChild("skill" + i, (FDWidget)skill);
        }
    }

    public void openSkillInfo(BossInfo info, boolean state) {
        if (!this.skillOpened && state) {
            if (info.getInfoStats() == null) {
                this.skillInfoText.setText(info.getInfoDescription(), 1.0f, this.getBaseStringColor(), true);
                this.skillInfoButton.setOnClickAction(null);
                this.skillStatsButton.setOnClickAction(null);
                this.skillInfoButton.setActive(false);
                this.skillStatsButton.setActive(false);
            } else {
                this.skillInfoText.setText(info.getInfoDescription(), 1.0f, this.getBaseStringColor(), true);
                this.skillInfoButton.setOnClickAction((fdWidget, v, v1, i) -> {
                    this.skillInfoText.setText(info.getInfoDescription(), 1.0f, this.getBaseStringColor(), true);
                    return true;
                });
                this.skillStatsButton.setOnClickAction((fdWidget, v, v1, i) -> {
                    this.skillInfoText.setText(info.getInfoStats(), 1.0f, this.getBaseStringColor(), true);
                    return true;
                });
                this.skillInfoButton.setActive(true);
                this.skillStatsButton.setActive(true);
            }
            this.skillInfoWidget.setSkillName(info.getInfoName(), this.getBaseStringColor());
            this.skillInfoWidget.setSkillImage(info.getInfoIcon());
            this.skillInfoWidget.moveWidgetTo(OPEN_TIME, 0.0f, 2.0f, FDEasings::easeOutBounce);
            this.skillOpened = true;
        } else if (this.skillOpened && !state) {
            this.skillInfoWidget.moveWidgetTo(OPEN_TIME / 2, -this.skillInfoWidget.getWidth(), 2.0f, FDEasings::easeIn);
            this.skillOpened = false;
        }
    }

    public void tick() {
        super.tick();
        this.openTicker = this.skillOpened ? Mth.clamp((int)(this.openTicker + 1), (int)0, (int)OPEN_TIME) : Mth.clamp((int)(this.openTicker - 1), (int)0, (int)OPEN_TIME);
        if (this.moveThings++ == 1) {
            this.bossDetailsWidget.moveWidgetTo(9, this.bossDetailsWidget.getX() - this.bossDetailsWidget.getWidth(), this.bossDetailsWidget.getY(), FDEasings::easeOut);
            this.bossAbilitesWidget.moveWidgetTo(9, this.bossAbilitesWidget.getX(), this.bossAbilitesWidget.getY() - this.bossAbilitesWidget.getHeight(), FDEasings::easeOut);
        }
    }

    public void render(GuiGraphics graphics, int mx, int my, float pticks) {
        this.renderBlurredBackground(pticks);
        PoseStack matrices = graphics.pose();
        Vector2f anchorEnd = this.getAnchor(1.0f, 1.0f);
        FDRenderUtil.fill((PoseStack)matrices, (float)0.0f, (float)0.0f, (float)anchorEnd.x, (float)anchorEnd.y, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f);
        this.renderBoss(graphics, mx, my, pticks);
        this.renderBack(graphics, mx, my, pticks);
        for (Renderable renderable : this.renderables) {
            if (renderable == this.skillInfoWidget || renderable == this.didntReadSkillWarningWidget) continue;
            renderable.render(graphics, mx, my, pticks);
        }
        this.renderSkillInfo(graphics, mx, my, pticks);
        this.renderDidntReadSkillInfoWidget(graphics, mx, my, pticks);
        this.renderSocialsWidget(graphics, mx, my, pticks);
    }

    private void renderDidntReadSkillInfoWidget(GuiGraphics graphics, int mx, int my, float pticks) {
        if (!this.didntReadSkillWarningWidget.isActive()) {
            return;
        }
        Vector2f anchorEnd = this.getAnchor(1.0f, 1.0f);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 200.0f);
        FDRenderUtil.fill((PoseStack)poseStack, (float)0.0f, (float)0.0f, (float)anchorEnd.x, (float)anchorEnd.y, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.925f);
        this.didntReadSkillWarningWidget.render(graphics, mx, my, pticks);
        poseStack.popPose();
    }

    private void renderSocialsWidget(GuiGraphics graphics, int mx, int my, float pticks) {
        if (!this.socialsWidget.isActive()) {
            return;
        }
        Vector2f anchorEnd = this.getAnchor(1.0f, 1.0f);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 200.0f);
        FDRenderUtil.fill((PoseStack)poseStack, (float)0.0f, (float)0.0f, (float)anchorEnd.x, (float)anchorEnd.y, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9f);
        this.socialsWidget.render(graphics, mx, my, pticks);
        poseStack.popPose();
    }

    private void renderSkillInfo(GuiGraphics graphics, int mx, int my, float pticks) {
        Vector2f anchorEnd = this.getAnchor(1.0f, 1.0f);
        PoseStack matrices = graphics.pose();
        matrices.pushPose();
        matrices.translate(0.0f, 0.0f, 200.0f);
        float a = (float)this.openTicker / (float)OPEN_TIME;
        a = this.skillOpened ? FDEasings.easeOut((float)FDEasings.easeOut((float)a)) : FDEasings.easeOut((float)a);
        FDRenderUtil.fill((PoseStack)matrices, (float)0.0f, (float)0.0f, (float)anchorEnd.x, (float)anchorEnd.y, (float)0.0f, (float)0.0f, (float)0.0f, (float)(a * 0.925f));
        this.skillInfoWidget.render(graphics, mx, my, pticks);
        matrices.popPose();
    }

    protected void renderBack(GuiGraphics graphics, float mx, float my, float pticks) {
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (this.didntReadSkillWarningWidget.isActive()) {
            if (FDRenderUtil.isMouseInBounds((float)((float)mx), (float)((float)my), (float)this.didntReadSkillWarningWidget.getX(), (float)this.didntReadSkillWarningWidget.getY(), (float)this.didntReadSkillWarningWidget.getWidth(), (float)this.didntReadSkillWarningWidget.getHeight())) {
                return this.didntReadSkillWarningWidget.mouseClicked(mx, my, button);
            }
            return false;
        }
        if (this.socialsWidget.isActive()) {
            if (FDRenderUtil.isMouseInBounds((float)((float)mx), (float)((float)my), (float)this.socialsWidget.getX(), (float)this.socialsWidget.getY(), (float)this.socialsWidget.getWidth(), (float)this.socialsWidget.getHeight())) {
                return this.socialsWidget.mouseClicked(mx, my, button);
            }
            this.socialsWidget.setActive(false);
            return false;
        }
        if (this.skillOpened) {
            float xBorder = this.skillInfoWidget.getX() + this.skillInfoWidget.getWidth();
            if (mx > (double)xBorder) {
                this.openSkillInfo(null, false);
                return false;
            }
            if (FDRenderUtil.isMouseInBounds((float)((float)mx), (float)((float)my), (float)this.skillInfoWidget.getX(), (float)this.skillInfoWidget.getY(), (float)this.skillInfoWidget.getWidth(), (float)this.skillInfoWidget.getHeight())) {
                return this.skillInfoWidget.mouseClicked(mx, my, button);
            }
            return false;
        }
        return super.mouseClicked(mx, my, button);
    }

    public abstract Component getBossName();

    public abstract int getBaseStringColor();

    protected abstract void renderBoss(GuiGraphics var1, float var2, float var3, float var4);

    public float getBossMenuXStart() {
        return this.bossMenuXStart;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

