/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.falling_block;

import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedBossBuddy;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdbosses.packets.SlamParticlesPacket;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.FDProjectile;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class ChesedFallingBlock
extends FDProjectile
implements AutoSerializable {
    public static final EntityDataAccessor<BlockState> STATE = SynchedEntityData.defineId(ChesedFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    @SerializableField
    public float damage;
    public boolean softerSound = false;

    public ChesedFallingBlock(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public static ChesedFallingBlock summon(Level level, BlockState state, Vec3 pos, Vec3 speed, float damage) {
        ChesedFallingBlock block = new ChesedFallingBlock(BossEntities.CHESED_FALLING_BLOCK.get(), level);
        block.setPos(pos);
        block.setDeltaMovement(speed);
        block.setBlockState(state);
        level.addFreshEntity((Entity)block);
        block.damage = damage;
        return block;
    }

    public static ChesedFallingBlock summon(Level level, BlockState state, Vec3 pos, float damage) {
        return ChesedFallingBlock.summon(level, state, pos, Vec3.ZERO, damage);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.applyGravity();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Vec3 pos = result.getLocation();
        if (!this.level().isClientSide) {
            float rd = 1.5f;
            AABB box = new AABB((double)(-rd), (double)(-rd), (double)(-rd), (double)rd, (double)rd, (double)rd).move(pos);
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, box, pr -> !(pr instanceof ChesedBossBuddy))) {
                if (this.damage != 0.0f) {
                    entity.hurt(BossDamageSources.CHESED_FALLING_BLOCK_SOURCE, this.damage);
                }
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)entity;
                PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(1.5f).stayTime(0).inTime(2).outTime(6).amplitude(15.0f).build(), (Vec3)pos, (double)5.0);
            }
            if (this.tickCount > 10) {
                float volume = 0.5f;
                if (this.softerSound) {
                    volume = 0.2f;
                }
                this.level().playSound(null, pos.x, pos.y, pos.z, BossSounds.ROCK_IMPACT.get(), SoundSource.HOSTILE, volume, 1.0f);
                SlamParticlesPacket packet = new SlamParticlesPacket(new SlamParticlesPacket.SlamData(result.getBlockPos(), pos.add(0.0, 0.5, 0.0), new Vec3(1.0, 0.0, 0.0)).maxAngle((float)Math.PI * 2).maxSpeed(0.3f).collectRadius(2).maxParticleLifetime(30).count(20).maxVerticalSpeedEdges(0.15f).maxVerticalSpeedCenter(0.15f));
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(STATE);
    }

    public void setBlockState(BlockState state) {
        this.entityData.set(STATE, (Object)state);
    }

    protected void defineSynchedData(SynchedEntityData.Builder data) {
        data.define(STATE, (Object)Blocks.STONE.defaultBlockState());
    }

    public boolean save(CompoundTag tag) {
        tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
        this.autoSave(tag);
        return super.save(tag);
    }

    public void load(CompoundTag tag) {
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("state")));
        this.autoLoad(tag);
        super.load(tag);
    }

    protected double getDefaultGravity() {
        return 0.025;
    }

    public boolean shouldRenderAtSqrDistance(double dist) {
        return dist < 14400.0;
    }
}

