/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_chain;

import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class MalkuthChainEntity
extends LivingEntity
implements AutoSerializable {
    private static final EntityDataAccessor<Integer> MALKUTH_ID = SynchedEntityData.defineId(MalkuthChainEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<MalkuthAttackType> MALKUTH_ATTACK_TYPE = SynchedEntityData.defineId(MalkuthChainEntity.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    @SerializableField
    private MalkuthAttackType malkuthAttackType;
    @SerializableField
    private UUID malkuthUUID;
    @SerializableField
    private UUID targetUUID;
    @SerializableField
    private int pullTime;
    @SerializableField
    private int catchTime;
    @SerializableField
    private Vec3 chainPullToPos;
    @SerializableField
    private Vec3 startingPos;

    public static MalkuthChainEntity summon(Level level, MalkuthEntity owner, MalkuthAttackType malkuthAttackType, Vec3 chainPullToPos, LivingEntity target, int pullTime, int catchTime) {
        MalkuthChainEntity chainEntity = new MalkuthChainEntity(BossEntities.MALKUTH_CHAIN.get(), level);
        chainEntity.setMalkuthAttackType(malkuthAttackType);
        chainEntity.targetUUID = target.getUUID();
        chainEntity.chainPullToPos = chainPullToPos;
        chainEntity.startingPos = chainEntity.getTargetAttachmentPos(target);
        chainEntity.setPos(chainPullToPos);
        chainEntity.pullTime = pullTime;
        chainEntity.catchTime = catchTime;
        chainEntity.malkuthUUID = owner.getUUID();
        level.addFreshEntity((Entity)chainEntity);
        return chainEntity;
    }

    public MalkuthChainEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setNoGravity(true);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            MalkuthEntity malkuthEntity = this.getMalkuth();
            if (malkuthEntity != null) {
                this.entityData.set(MALKUTH_ID, (Object)malkuthEntity.getId());
            }
            if (malkuthEntity == null || this.getTarget() == null || this.getTarget().isDeadOrDying()) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
            }
            this.moveToTargetEndPoint();
        }
    }

    private void moveToTargetEndPoint() {
        if (this.tickCount > this.catchTime && this.tickCount - this.catchTime <= this.pullTime) {
            float p = (float)(this.tickCount - this.catchTime) / (float)this.pullTime;
            Vec3 targetPoint = FDMathUtil.interpolateVectors((Vec3)this.startingPos, (Vec3)this.chainPullToPos, (float)p);
            Vec3 current = this.position();
            Vec3 deltaMovement = targetPoint.subtract(current);
            this.setDeltaMovement(deltaMovement);
            LivingEntity target = this.getTarget();
            if (target != null && !this.hasPassenger((Entity)target)) {
                target.startRiding((Entity)this, true);
            }
        } else if (this.tickCount <= this.catchTime) {
            LivingEntity target = this.getTarget();
            if (target == null) {
                return;
            }
            Vec3 targetAttachmentPos = this.getTargetAttachmentPos(target);
            float p = (float)this.tickCount / (float)this.pullTime;
            Vec3 targetPoint = FDMathUtil.interpolateVectors((Vec3)this.chainPullToPos, (Vec3)targetAttachmentPos, (float)p);
            Vec3 current = this.position();
            Vec3 deltaMovement = targetPoint.subtract(current);
            this.setDeltaMovement(deltaMovement);
            if (this.tickCount == this.catchTime) {
                this.startingPos = targetAttachmentPos;
                this.setPos(targetAttachmentPos);
            }
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public Vec3 getTargetAttachmentPos(LivingEntity target) {
        return target.position().add(0.0, (double)(target.getBbHeight() / 2.0f - 1.0f), 0.0);
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(0.0, (double)(-entity.getBbHeight() / 2.0f) + 0.25, 0.0);
    }

    public LivingEntity getTarget() {
        Entity entity;
        if (this.targetUUID != null && !this.level().isClientSide && (entity = ((ServerLevel)this.level()).getEntity(this.targetUUID)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    public MalkuthEntity getMalkuth() {
        if (!this.level().isClientSide) {
            if (this.malkuthUUID != null) {
                Entity entity = ((ServerLevel)this.level()).getEntity(this.malkuthUUID);
                if (entity instanceof MalkuthEntity) {
                    MalkuthEntity malkuthEntity = (MalkuthEntity)entity;
                    return malkuthEntity;
                }
                return null;
            }
            return null;
        }
        Entity entity = this.level().getEntity(((Integer)this.entityData.get(MALKUTH_ID)).intValue());
        if (entity instanceof MalkuthEntity) {
            MalkuthEntity malkuthEntity = (MalkuthEntity)entity;
            return malkuthEntity;
        }
        return null;
    }

    protected Vec3 getMalkuthHandPos(float pticks) {
        MalkuthEntity malkuthEntity = this.getMalkuth();
        if (malkuthEntity != null) {
            String name = ((MalkuthAttackType)((Object)this.entityData.get(MALKUTH_ATTACK_TYPE))).isFire() ? "fire_sword_place" : "ice_sword_place";
            Matrix4f mt = malkuthEntity.getModelPartTransformation((Entity)malkuthEntity, name, MalkuthEntity.getClientModel(), pticks);
            Vector3f p = mt.transformPosition(new Vector3f());
            Vec3 mpos = malkuthEntity.getPosition(pticks);
            return new Vec3((double)p.x + mpos.x, (double)p.y + mpos.y, (double)p.z + mpos.z);
        }
        return null;
    }

    public void setMalkuthAttackType(MalkuthAttackType malkuthAttackType) {
        this.malkuthAttackType = malkuthAttackType;
        this.entityData.set(MALKUTH_ATTACK_TYPE, (Object)malkuthAttackType);
    }

    private void setCatchTime(int catchTime) {
        this.catchTime = catchTime;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.LEFT;
    }

    public boolean hurt(DamageSource src, float p_21017_) {
        if (!src.is(DamageTypes.GENERIC_KILL)) {
            return false;
        }
        return super.hurt(src, p_21017_);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getItemBySlot(EquipmentSlot p_21127_) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot p_21036_, ItemStack p_21037_) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MALKUTH_ID, (Object)-1);
        builder.define(MALKUTH_ATTACK_TYPE, (Object)MalkuthAttackType.FIRE);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.autoSave(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.autoLoad(tag);
        this.setMalkuthAttackType(this.malkuthAttackType);
        this.setCatchTime(this.catchTime);
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }

    public void push(double p_20286_, double p_20287_, double p_20288_) {
    }

    public void push(Entity p_21294_) {
    }

    public void push(Vec3 p_347665_) {
    }

    protected void pushEntities() {
    }
}

