/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.structures;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.init.BossStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class MalkuthArenaStructure
extends Structure {
    public static final MapCodec<MalkuthArenaStructure> CODEC = RecordCodecBuilder.mapCodec(p -> p.group((App)MalkuthArenaStructure.settingsCodec((RecordCodecBuilder.Instance)p), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool)).apply((Applicative)p, MalkuthArenaStructure::new));
    private final Holder<StructureTemplatePool> startPool;

    public MalkuthArenaStructure(Structure.StructureSettings structureSettings, Holder<StructureTemplatePool> startPool) {
        super(structureSettings);
        this.startPool = startPool;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext ctx) {
        ChunkPos chunkpos = ctx.chunkPos();
        BlockPos blockpos = new BlockPos(chunkpos.getMinBlockX() + 8, -3, chunkpos.getMinBlockZ() + 8);
        int maxDistanceFromCenter = 128;
        return JigsawPlacement.addPieces((Structure.GenerationContext)ctx, this.startPool, Optional.of(FDBosses.location("malkuth_arena_part_1")), (int)20, (BlockPos)blockpos, (boolean)false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), (int)maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.create(new ArrayList(), (BlockPos)blockpos, (long)ctx.seed()), (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.IGNORE_WATERLOGGING);
    }

    public StructureType<?> type() {
        return BossStructures.MALKUTH_ARENA.get();
    }
}

