/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.impact_frames;

import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.init.FDConfigs;
import com.finderfeed.fdlib.systems.impact_frames.ImpactFrame;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Vector2i;
import org.lwjgl.opengl.GL11;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT}, modid="fdlib")
public class ImpactFramesHandler {
    public static boolean wasImpactFrameShaderActive = false;
    private static final Queue<ImpactFrame> impactFrames = new ArrayDeque<ImpactFrame>();
    private static int width = -1;
    private static int height = -1;
    private static ImpactFrame currentImpactFrame = null;
    private static int currentTick = 0;
    public static PostChain impactFrameShader;

    @SubscribeEvent
    public static void tick(ClientTickEvent.Pre event) {
        ImpactFramesHandler.manageImpactFrames();
    }

    private static void manageImpactFrames() {
        if (impactFrameShader == null) {
            return;
        }
        ImpactFramesHandler.resizeImpactShaderIfNeeded();
        GameRenderer renderer = Minecraft.getInstance().gameRenderer;
        if (currentImpactFrame == null) {
            if (!impactFrames.isEmpty()) {
                currentImpactFrame = impactFrames.poll();
                ImpactFramesHandler.activateImpactShader(currentImpactFrame);
                currentTick = 1;
            } else if (wasImpactFrameShaderActive) {
                currentTick = 0;
                renderer.postEffect = null;
                renderer.effectActive = false;
                wasImpactFrameShaderActive = false;
            }
        } else if (currentTick >= currentImpactFrame.getDuration()) {
            if (!impactFrames.isEmpty()) {
                currentImpactFrame = impactFrames.poll();
                ImpactFramesHandler.activateImpactShader(currentImpactFrame);
                currentTick = 1;
            } else {
                currentImpactFrame = null;
                currentTick = 0;
                renderer.postEffect = null;
                renderer.effectActive = false;
            }
        } else {
            ImpactFramesHandler.activateImpactShader(currentImpactFrame);
            ++currentTick;
        }
    }

    private static void activateImpactShader(ImpactFrame frame) {
        GameRenderer renderer = Minecraft.getInstance().gameRenderer;
        if (renderer.postEffect == null || renderer.postEffect.equals(impactFrameShader)) {
            impactFrameShader.setUniform("treshhold", frame.getTreshhold());
            impactFrameShader.setUniform("treshholdLerp", frame.getTreshholdLerp());
            impactFrameShader.setUniform("invert", frame.isInverted() ? 1.0f : 0.0f);
            renderer.postEffect = impactFrameShader;
            renderer.effectActive = true;
            wasImpactFrameShaderActive = true;
        }
    }

    public static void beforePostEffect(DeltaTracker deltaTracker, boolean idk) {
        if (ImpactFramesHandler.isImpactFrameShaderActive()) {
            RenderTarget main = Minecraft.getInstance().getMainRenderTarget();
            main.bindRead();
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            float[] pixel = new float[3];
            int hhalfW = width / 4;
            int hhalfH = height / 4;
            Vector2i[] samplePoints = new Vector2i[]{new Vector2i(hhalfW, hhalfH), new Vector2i(hhalfW * 2, hhalfH), new Vector2i(hhalfW * 3, hhalfH), new Vector2i(hhalfW, hhalfH * 2), new Vector2i(hhalfW * 2, hhalfH * 2), new Vector2i(hhalfW * 3, hhalfH * 2), new Vector2i(hhalfW, hhalfH * 3), new Vector2i(hhalfW * 2, hhalfH * 3), new Vector2i(hhalfW * 3, hhalfH * 3)};
            float maxGrayscale = 0.0f;
            for (Vector2i point : samplePoints) {
                GL11.glReadPixels((int)point.x, (int)point.y, (int)1, (int)1, (int)6407, (int)5126, (float[])pixel);
                float grayscale = Math.max(pixel[0], Math.max(pixel[1], pixel[2]));
                maxGrayscale = Math.max(maxGrayscale, grayscale);
            }
            impactFrameShader.setUniform("maxEstimatedGrayscale", maxGrayscale);
        }
    }

    public static boolean isImpactFrameShaderActive() {
        GameRenderer renderer = Minecraft.getInstance().gameRenderer;
        return renderer.postEffect != null && renderer.postEffect.getName().equals(impactFrameShader.getName());
    }

    public static void addImpactFrame(ImpactFrame frame) {
        if (FDConfigs.CLIENTSIDE_CONFIG.get().impactFramesEnabled) {
            impactFrames.offer(frame);
        }
    }

    private static void resizeImpactShaderIfNeeded() {
        Window window = Minecraft.getInstance().getWindow();
        if (width != window.getWidth() || height != window.getHeight()) {
            impactFrameShader.resize(window.getWidth(), window.getHeight());
            width = window.getWidth();
            height = window.getHeight();
        }
    }

    public static void initializeImpactShaderOrResizeIfNeeded(boolean forceReload) throws IOException {
        Window window;
        if (impactFrameShader == null || forceReload) {
            if (impactFrameShader != null) {
                impactFrameShader.close();
            }
            impactFrameShader = new PostChain(Minecraft.getInstance().getTextureManager(), (ResourceProvider)Minecraft.getInstance().getResourceManager(), Minecraft.getInstance().getMainRenderTarget(), FDLib.location("shaders/post/impact_frame.json"));
        }
        if (width != (window = Minecraft.getInstance().getWindow()).getWidth() || height != window.getHeight() || forceReload) {
            impactFrameShader.resize(window.getWidth(), window.getHeight());
            width = window.getWidth();
            height = window.getHeight();
        }
    }
}

