/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle;

import com.finderfeed.fdlib.systems.particle.FDParticleProcessors;
import com.finderfeed.fdlib.systems.particle.ParticleProcessorType;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public interface ParticleProcessor<T extends ParticleProcessor<T>> {
    public static final Codec<ResourceLocation> RL_CODEC = ResourceLocation.CODEC.fieldOf("type").codec();
    public static final Codec<ParticleProcessor<?>> CODEC = new Codec<ParticleProcessor<?>>(){

        public <D> DataResult<Pair<ParticleProcessor<?>, D>> decode(DynamicOps<D> ops, D input) {
            DataResult result = RL_CODEC.decode(ops, input);
            ResourceLocation location = (ResourceLocation)((Pair)result.getOrThrow()).getFirst();
            ParticleProcessorType<?> type = FDParticleProcessors.getType(location);
            Codec<?> particleProcessorCodec = type.codec();
            DataResult processorResult = particleProcessorCodec.decode(ops, input);
            return processorResult;
        }

        public <D> DataResult<D> encode(ParticleProcessor<?> value, DynamicOps<D> ops, D prefix) {
            ParticleProcessorType<?> type = value.type();
            Codec<?> codec = type.codec();
            DataResult result = RL_CODEC.encode((Object)type.id(), ops, prefix).flatMap(f -> codec.encode((Object)value, ops, f));
            return result;
        }
    };
    public static final StreamCodec<FriendlyByteBuf, ParticleProcessor<?>> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ParticleProcessor<?>>(){

        public ParticleProcessor<?> decode(FriendlyByteBuf buf) {
            ResourceLocation location = buf.readResourceLocation();
            ParticleProcessorType<?> type = FDParticleProcessors.getType(location);
            StreamCodec<FriendlyByteBuf, ?> codec = type.streamCodec();
            return (ParticleProcessor)codec.decode((Object)buf);
        }

        public void encode(FriendlyByteBuf buf, ParticleProcessor<?> processor) {
            buf.writeResourceLocation(processor.type().id());
            ParticleProcessor.hackyEncode(buf, processor, processor.type().streamCodec());
        }
    };

    public ParticleProcessorType<T> type();

    public void processParticle(Particle var1);

    public void init(Particle var1);

    private static <T extends ParticleProcessor<T>> void hackyEncode(FriendlyByteBuf buf, ParticleProcessor<?> processor, StreamCodec<FriendlyByteBuf, T> encoder) {
        encoder.encode((Object)buf, processor);
    }
}

