/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.screen_effect;

import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffect;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectOverlay;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectType;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdlib:screen_effect")
public class SendScreenEffectPacket<D extends ScreenEffectData, T extends ScreenEffect<D>>
extends FDPacket {
    private D data;
    private ScreenEffectType<D, T> type;
    private int inTime;
    private int stayTime;
    private int outTime;

    public SendScreenEffectPacket(D data, ScreenEffectType<D, T> type, int inTime, int stayTime, int outTime) {
        this.data = data;
        this.type = type;
        this.stayTime = stayTime;
        this.outTime = outTime;
        this.inTime = inTime;
    }

    public SendScreenEffectPacket(RegistryFriendlyByteBuf buf) {
        RegistryAccess access = buf.registryAccess();
        Registry registry = access.registryOrThrow(FDRegistries.SCREEN_EFFECTS_KEY);
        String location = buf.readUtf();
        ScreenEffectType t = (ScreenEffectType)registry.get(ResourceLocation.parse((String)location));
        ScreenEffectData effectData = (ScreenEffectData)t.dataCodec.decode((Object)buf);
        this.data = effectData;
        this.type = t;
        this.inTime = buf.readInt();
        this.stayTime = buf.readInt();
        this.outTime = buf.readInt();
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        RegistryAccess access = buf.registryAccess();
        Registry registry = access.registryOrThrow(FDRegistries.SCREEN_EFFECTS_KEY);
        ResourceLocation location = registry.getKey(this.type);
        buf.writeUtf(location.toString());
        this.type.dataCodec.encode((Object)buf, this.data);
        buf.writeInt(this.inTime);
        buf.writeInt(this.stayTime);
        buf.writeInt(this.outTime);
    }

    @Override
    public void clientAction(IPayloadContext context) {
        Object effect = this.type.factory.create(this.data, this.inTime, this.stayTime, this.outTime);
        ScreenEffectOverlay.addScreenEffect(effect);
    }

    @Override
    public void serverAction(IPayloadContext context) {
    }
}

