/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.client;

import dev.ftb.mods.ftbbackups.FTBBackups;
import dev.ftb.mods.ftbbackups.client.BackupsClient;
import dev.ftb.mods.ftbbackups.config.FTBBackupsClientConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BackupOverlayLayer
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = FTBBackups.id("overlay");
    private int prevProgress;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!((Boolean)FTBBackupsClientConfig.SHOW_OVERLAY.get()).booleanValue() || BackupsClient.isDisabledOnThisServer()) {
            return;
        }
        BackupsClient.BackupProgress progress = BackupsClient.getBackupProgress();
        if (!progress.inProgress()) {
            return;
        }
        MutableComponent line1 = progress.finished() ? Component.translatable((String)"ftbbackups3.lang.finished") : Component.translatable((String)"ftbbackups3.lang.already_running");
        MutableComponent line2 = BackupsClient.progressMessage();
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        int width = mc.getWindow().getGuiScaledWidth() / 4;
        Objects.requireNonNull(font);
        int progressBarHeight = 9 + 4;
        Objects.requireNonNull(font);
        int height = 9 + progressBarHeight + 8;
        float scale = 1.0f;
        int insetX = (Integer)FTBBackupsClientConfig.OVERLAY_INSET_X.get();
        int insetY = (Integer)FTBBackupsClientConfig.OVERLAY_INSET_Y.get();
        PanelPositioning.PanelPos pos = ((PanelPositioning)FTBBackupsClientConfig.OVERLAY_POS.get()).getPanelPos(mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight(), (int)((float)width * scale), (int)((float)height * scale), insetX, insetY);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)pos.x(), (float)pos.y(), 100.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        Color4I.rgba((int)-2145386464).draw(guiGraphics, -2, -2, width + 4, height + 4);
        GuiHelper.drawHollowRect((GuiGraphics)guiGraphics, (int)-2, (int)-2, (int)(width + 4), (int)(height + 4), (Color4I)Color4I.rgba((int)-2143289280), (boolean)false);
        guiGraphics.drawString(font, (Component)line1, 2, 2, -329226, false);
        int pw = (int)((float)(width - 4) * Mth.lerp((float)deltaTracker.getGameTimeDeltaTicks(), (float)this.prevProgress, (float)progress.current()) / (float)progress.total());
        Objects.requireNonNull(font);
        int sy = 9 + 4;
        guiGraphics.fill(2, sy - 1, width - 3, sy + progressBarHeight + 1, -1073717024);
        guiGraphics.fill(3, sy, pw, sy + progressBarHeight, -1073725280);
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, (Component)line2, 14, 2 + 9 + 5, -329226, false);
        guiGraphics.pose().popPose();
        this.prevProgress = progress.current();
    }
}

