/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client;

import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.EchoStage;
import dev.ftb.mods.ftbechoes.shopping.ShopData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public enum ShopSummary {
    INSTANCE;

    private final Int2ObjectMap<List<SummaryItem>> byItemHash = new Int2ObjectOpenHashMap();
    private final List<SummaryItem> allShopData = new ArrayList<SummaryItem>();

    public List<SummaryItem> getAllShopData() {
        return Collections.unmodifiableList(this.allShopData);
    }

    public boolean hasShopData(ItemStack stack) {
        return this.byItemHash.containsKey(ShopSummary.itemKey(stack));
    }

    public List<SummaryItem> getShopDataFor(ItemStack stack) {
        return (List)this.byItemHash.getOrDefault(ShopSummary.itemKey(stack), List.of());
    }

    public void buildSummary() {
        this.byItemHash.clear();
        this.allShopData.clear();
        for (Echo echo : EchoManager.getClientInstance().getEchoes()) {
            for (EchoStage stage : echo.stages()) {
                for (ShopData data : stage.shopUnlocked()) {
                    if (data.stacks().isEmpty()) continue;
                    SummaryItem summary = new SummaryItem(data, echo.title(), stage.title());
                    for (ItemStack stack : data.stacks()) {
                        int key = ShopSummary.itemKey(stack);
                        ((List)this.byItemHash.computeIfAbsent(key, k -> new ArrayList())).add(summary);
                    }
                    this.allShopData.add(summary);
                }
            }
        }
    }

    private static int itemKey(ItemStack stack) {
        return BuiltInRegistries.ITEM.getId((Object)stack.getItem());
    }

    public record SummaryItem(ShopData data, Component echoTitle, Component stageTitle) {
    }
}

