/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.gui;

import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.client.ClientProgress;
import dev.ftb.mods.ftbechoes.client.gui.EchoSoundClipHandler;
import dev.ftb.mods.ftbechoes.client.gui.LorePanel;
import dev.ftb.mods.ftbechoes.client.gui.ShopPanel;
import dev.ftb.mods.ftbechoes.client.gui.Textures;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.net.PlaceOrderMessage;
import dev.ftb.mods.ftbechoes.net.SelectEchoMessage;
import dev.ftb.mods.ftbechoes.shopping.ShoppingBasket;
import dev.ftb.mods.ftbechoes.shopping.ShoppingKey;
import dev.ftb.mods.ftbechoes.util.MiscUtil;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class EchoScreen
extends AbstractThreePanelScreen<MainPanel> {
    static Map<ResourceLocation, Page> currentPage = new HashMap<ResourceLocation, Page>();
    private final BlockPos projectorPos;
    private boolean pendingScrollToEnd;
    @Nullable
    private Echo echo;

    public EchoScreen(BlockPos projectorPos, @Nullable Echo echo) {
        this.projectorPos = projectorPos;
        this.echo = echo;
        this.showCloseButton(false);
    }

    public void setEcho(Echo echo) {
        this.echo = echo;
        ((TopPanel)this.topPanel).tabButtons.invalidate();
        ((MainPanel)this.mainPanel).pages.invalidate();
        this.refreshWidgets();
    }

    public boolean onInit() {
        boolean ok = this.setSizeProportional(0.85f, 0.8f);
        this.setWidth(Math.min(this.getWidth(), 600));
        return ok;
    }

    public void onPostInit() {
        if (this.getCurrentPage() == Page.LORE) {
            this.scrollBar.setValue(this.scrollBar.getMaxValue());
        }
    }

    public void onClosed() {
        if (EchoSoundClipHandler.INSTANCE.isPlayingSound() && Minecraft.getInstance().screen != null && Minecraft.getInstance().player != null) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"ftbechoes.message.hold_alt_to_stop_sound").withStyle(ChatFormatting.AQUA), true);
        }
    }

    protected void doCancel() {
    }

    protected void doAccept() {
    }

    protected int getTopPanelHeight() {
        return 25 + this.getTheme().getFontHeight() + 9;
    }

    protected Panel createTopPanel() {
        return new TopPanel();
    }

    protected MainPanel createMainPanel() {
        return new MainPanel();
    }

    protected Panel createBottomPanel() {
        return new BottomPanel(this, (Panel)this);
    }

    public void alignWidgets() {
        super.alignWidgets();
        if (this.pendingScrollToEnd) {
            this.scrollBar.setValue(this.scrollBar.getMaxValue());
            this.pendingScrollToEnd = false;
        }
    }

    public Page getCurrentPage() {
        return this.echo == null ? Page.LORE : currentPage.getOrDefault(this.echo.id(), Page.LORE);
    }

    private void setCurrentPage(Page page) {
        if (this.echo != null) {
            currentPage.put(this.echo.id(), page);
        }
    }

    public void onProgressUpdated() {
        this.refreshWidgets();
        if (this.getCurrentPage() == Page.LORE) {
            this.pendingScrollToEnd = true;
        }
    }

    public BlockPos getProjectorPos() {
        return this.projectorPos;
    }

    private class TopPanel
    extends Panel {
        private final TextField label;
        private final Button settingsButton;
        private final Button stopAudioButton;
        private final Lazy<Map<Page, PageButton>> tabButtons;
        private final boolean adminPlayer;

        public TopPanel() {
            super((Panel)EchoScreen.this);
            this.tabButtons = Lazy.of(this::buildTabButtons);
            LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
            this.adminPlayer = player.hasPermissions(2) && player.isCreative();
            this.label = new TextField((Panel)this);
            this.settingsButton = SimpleTextButton.create((Panel)this, (Component)Component.empty(), (Icon)Icons.SETTINGS, this::showEchoSelector, (Component[])new Component[0]);
            this.stopAudioButton = new StopAudioButton(this);
        }

        private Map<Page, PageButton> buildTabButtons() {
            EnumMap<Page, PageButton> res = new EnumMap<Page, PageButton>(Page.class);
            res.put(Page.LORE, new PageButton(Page.LORE, this, Icons.BOOK));
            if (EchoScreen.this.echo != null && EchoScreen.this.echo.hasAnyShopItems()) {
                res.put(Page.SHOP, new PageButton(Page.SHOP, this, Icons.MONEY_BAG));
            }
            ((PageButton)((Object)res.get((Object)Page.LORE))).setDropdownAction(this::showStageSelector, () -> EchoScreen.this.echo != null && ClientProgress.get().isStageCompleted(EchoScreen.this.echo.id(), 0));
            return res;
        }

        private Map<Page, PageButton> getTabButtons() {
            return (Map)this.tabButtons.get();
        }

        public void addWidgets() {
            if (this.adminPlayer) {
                this.add((Widget)this.settingsButton);
            }
            this.add((Widget)this.stopAudioButton);
            if (EchoScreen.this.echo == null) {
                this.add((Widget)this.label.setText((Component)Component.translatable((String)"ftbechoes.message.no_echo").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD})));
            } else {
                this.add((Widget)this.label.setText((Component)Component.empty().withStyle(ChatFormatting.YELLOW).append(EchoScreen.this.echo.title())));
            }
            this.addAll(this.getTabButtons().values());
        }

        public void alignWidgets() {
            this.settingsButton.setPosAndSize(this.width - 18, 2, 16, 16);
            this.stopAudioButton.setPosAndSize(this.width - (this.adminPlayer ? 36 : 18), 2, 16, 16);
            this.label.setPos(4, 5);
            this.label.setWidth(this.width);
            int bw = this.width / (this.getTabButtons().size() + 1) - 4;
            int by = EchoScreen.this.getTheme().getFontHeight() + 8;
            for (PageButton w : this.getTabButtons().values()) {
                w.setPosAndSize(4 + w.page.ordinal() * (bw + 2), by, bw, this.height - by);
            }
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            super.drawBackground(graphics, theme, x, y, w, h);
            int col = -10986138;
            graphics.hLine(x, x + this.getTabButtons().get((Object)((Object)Page.LORE)).posX - 1, y + this.height - 2, col);
            if (EchoScreen.this.echo != null && EchoScreen.this.echo.hasAnyShopItems()) {
                graphics.hLine(x + this.getTabButtons().get((Object)((Object)Page.LORE)).posX + this.getTabButtons().get((Object)((Object)Page.LORE)).width, x + this.getTabButtons().get((Object)((Object)Page.SHOP)).posX - 1, y + this.height - 2, col);
                graphics.hLine(x + this.getTabButtons().get((Object)((Object)Page.SHOP)).posX + this.getTabButtons().get((Object)((Object)Page.SHOP)).width, x + this.width - 1, y + this.height - 2, col);
            } else {
                graphics.hLine(x + this.getTabButtons().get((Object)((Object)Page.LORE)).posX + this.getTabButtons().get((Object)((Object)Page.LORE)).width, x + this.width - 1, y + this.height - 2, col);
            }
            graphics.hLine(x, x + this.width - 1, y + this.height - 1, NordColors.POLAR_NIGHT_1.rgba());
        }

        public boolean keyPressed(Key key) {
            if (key.is(334) || key.is(61)) {
                this.collapseAll(false);
                return true;
            }
            if (key.is(45) || key.is(333)) {
                this.collapseAll(true);
                return true;
            }
            return super.keyPressed(key);
        }

        private void showEchoSelector(MouseButton mb) {
            EchoScreen.this.openContextMenu((List)Util.make(new ArrayList(), list -> EchoManager.getClientInstance().getEchoes().forEach(echo -> {
                Icon icon = this.isCurrentEcho((Echo)echo) ? Icons.CHECK : Icon.empty();
                list.add(new ContextMenuItem(echo.title(), icon, btn -> this.selectEcho((Echo)echo)));
            })));
        }

        private void showStageSelector() {
            if (EchoScreen.this.echo == null) {
                return;
            }
            EchoScreen.this.openContextMenu((List)Util.make(new ArrayList(), list -> {
                list.add(ContextMenuItem.title((Component)Component.translatable((String)"ftbechoes.gui.stages")));
                list.add(ContextMenuItem.separator());
                for (int i = 0; i < EchoScreen.this.echo.stages().size(); ++i) {
                    int stageIdx = i;
                    if (!ClientProgress.get().isStageCompleted(EchoScreen.this.echo.id(), i)) continue;
                    list.add(new ContextMenuItem(EchoScreen.this.echo.stages().get(stageIdx).title(), Icons.BLUE_BUTTON, btn -> this.scrollToStage(stageIdx)));
                }
                list.add(ContextMenuItem.separator());
                list.add(new ContextMenuItem((Component)Component.translatable((String)"ftbechoes.gui.expand_all").append((Component)Component.literal((String)" [+]").withStyle(ChatFormatting.GRAY)), Icons.EXPAND, btn -> this.collapseAll(false)));
                list.add(new ContextMenuItem((Component)Component.translatable((String)"ftbechoes.gui.collapse_all").append((Component)Component.literal((String)" [-]").withStyle(ChatFormatting.GRAY)), Icons.COLLAPSE, btn -> this.collapseAll(true)));
            }));
        }

        private void selectEcho(Echo echo) {
            if (!this.isCurrentEcho(echo)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SelectEchoMessage(EchoScreen.this.projectorPos, echo.id()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        private void scrollToStage(int stageIdx) {
            PagePanel pagePanel = ((MainPanel)EchoScreen.this.mainPanel).getPages().get((Object)Page.LORE);
            if (pagePanel instanceof LorePanel) {
                LorePanel lorePanel = (LorePanel)pagePanel;
                if (lorePanel.isCollapsed(stageIdx)) {
                    lorePanel.setCollapsed(stageIdx, false);
                }
                EchoScreen.this.scrollBar.setValue(lorePanel.getScrollPos(stageIdx));
            }
        }

        private void collapseAll(boolean collapse) {
            this.playClickSound();
            PagePanel pagePanel = ((MainPanel)EchoScreen.this.mainPanel).getPages().get((Object)Page.LORE);
            if (pagePanel instanceof LorePanel) {
                LorePanel lorePanel = (LorePanel)pagePanel;
                lorePanel.setAllCollapsed(collapse);
            }
        }

        private boolean isCurrentEcho(Echo e) {
            return EchoScreen.this.echo != null && e.id().equals((Object)EchoScreen.this.echo.id());
        }

        private class StopAudioButton
        extends SimpleTextButton {
            private static final Icon STOP_AUDIO_ICON = Icon.getIcon((ResourceLocation)Textures.STOP_AUDIO);

            public StopAudioButton(TopPanel topPanel) {
                super((Panel)topPanel, (Component)Component.empty(), STOP_AUDIO_ICON);
            }

            public void onClicked(MouseButton mouseButton) {
                EchoSoundClipHandler.INSTANCE.stopPlayingSound();
            }

            public boolean shouldDraw() {
                return this.isEnabled();
            }

            public boolean isEnabled() {
                return EchoSoundClipHandler.INSTANCE.isPlayingSound();
            }

            public void addMouseOverText(TooltipList list) {
                if (this.shouldDraw()) {
                    list.add((Component)Component.translatable((String)"ftbechoes.gui.stop_audio"));
                }
            }
        }
    }

    public class MainPanel
    extends Panel {
        private final Lazy<Map<Page, PagePanel>> pages;

        public MainPanel() {
            super((Panel)EchoScreen.this);
            this.pages = Lazy.of(this::buildPages);
        }

        private Map<Page, PagePanel> buildPages() {
            EnumMap<Page, PagePanel> map = new EnumMap<Page, PagePanel>(Page.class);
            map.put(Page.LORE, new LorePanel(this, EchoScreen.this));
            if (EchoScreen.this.echo != null && EchoScreen.this.echo.hasAnyShopItems()) {
                map.put(Page.SHOP, new ShopPanel(this, EchoScreen.this));
            }
            return map;
        }

        private Map<Page, PagePanel> getPages() {
            return (Map)this.pages.get();
        }

        public void addWidgets() {
            this.addAll(this.getPages().values());
        }

        public void alignWidgets() {
            this.getPages().values().forEach(p -> {
                p.setPosAndSize(0, 0, this.width, this.height);
                p.alignWidgets();
            });
            if (this.getContentHeight() <= this.getHeight()) {
                EchoScreen.this.scrollBar.setValue(0.0);
            }
        }

        private PagePanel getCurrentPagePanel() {
            PagePanel res = this.getPages().get((Object)EchoScreen.this.getCurrentPage());
            if (res == null) {
                EchoScreen.this.setCurrentPage(Page.LORE);
                return this.getPages().get((Object)Page.LORE);
            }
            return res;
        }

        public int getContentHeight() {
            return this.getCurrentPagePanel().getContentHeight();
        }

        public void storeScrollPos() {
            this.getCurrentPagePanel().storeScrollPos();
        }

        public double fetchScrollPos() {
            return this.getCurrentPagePanel().fetchScrollPos();
        }

        public void onSwitchAway() {
            this.getCurrentPagePanel().onSwitchAway();
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_0.draw(graphics, x, y, w, h);
        }
    }

    public static enum Page {
        LORE("lore"),
        SHOP("shop");

        private final String name;

        private Page(String name) {
            this.name = name;
        }

        public Component getLabel() {
            return Component.translatable((String)("ftbechoes.gui.page." + this.name));
        }
    }

    private class BottomPanel
    extends Panel {
        private final PurchaseButton purchaseButton;

        public BottomPanel(EchoScreen echoScreen, Panel panel) {
            super(panel);
            this.purchaseButton = echoScreen.new PurchaseButton(this);
        }

        public void addWidgets() {
            this.add((Widget)this.purchaseButton);
        }

        public void alignWidgets() {
            this.purchaseButton.setPos(this.width - this.purchaseButton.width - 5, 2);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(graphics, x, y, w, h);
            Color4I.GRAY.withAlpha(64).draw(graphics, x, y, w, 1);
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
            Component c = MiscUtil.formatCost(FTBEchoes.currencyProvider().getTotalCurrency((Player)Minecraft.getInstance().player));
            theme.drawString(graphics, (Object)Component.translatable((String)"ftbechoes.gui.wallet", (Object[])new Object[]{c}), x + 5, y + 8, Color4I.GREEN.rgba());
        }
    }

    private class PageButton
    extends SimpleTextButton {
        private final Page page;
        private Runnable onDropDownClicked;
        private BooleanSupplier dropdownPredicate;

        public PageButton(Page page, Panel panel, Icon icon) {
            super(panel, page.getLabel(), icon);
            this.onDropDownClicked = null;
            this.dropdownPredicate = () -> false;
            this.page = page;
        }

        public void setDropdownAction(Runnable onClicked, BooleanSupplier predicate) {
            this.onDropDownClicked = onClicked;
            this.dropdownPredicate = predicate;
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            this.drawBackground(graphics, theme, x, y, w, h);
            int iconSize = 12;
            int off = (h - iconSize) / 2;
            Component title = this.getTitle();
            int textX = x + 4;
            int textY = y + (h - theme.getFontHeight() + 1) / 2;
            int sw = theme.getStringWidth((FormattedText)title);
            int mw = w - off + iconSize - 6;
            if (sw > mw) {
                title = theme.trimStringToWidth((FormattedText)title, mw);
            }
            this.drawIcon(graphics, theme, x + off, y + off + 1, iconSize, iconSize);
            theme.drawString(graphics, (Object)title, textX += off + iconSize, textY + 1, theme.getContentColor(this.getWidgetType()), 0);
            if (this.dropdownPredicate.getAsBoolean() && this.onDropDownClicked != null) {
                int x1 = x + this.width - 16;
                int x2 = x + this.width - 6;
                int y0 = y + this.height / 2;
                graphics.hLine(x1, x2, y0 - 3, theme.getContentColor(WidgetType.NORMAL).rgba());
                graphics.hLine(x1, x2, y0, theme.getContentColor(WidgetType.NORMAL).rgba());
                graphics.hLine(x1, x2, y0 + 3, theme.getContentColor(WidgetType.NORMAL).rgba());
            }
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawHorizontalTab(graphics, x, y, w, h, EchoScreen.this.getCurrentPage() == this.page);
        }

        public void onClicked(MouseButton mouseButton) {
            if (this.dropdownPredicate.getAsBoolean() && EchoScreen.this.getCurrentPage() == this.page && this.getMouseX() < this.getX() + this.width - 4 && this.getMouseX() > this.getX() + this.width - 18) {
                this.onDropDownClicked.run();
                return;
            }
            MainPanel mainPanel = (MainPanel)EchoScreen.this.mainPanel;
            PanelScrollBar scrollBar = EchoScreen.this.scrollBar;
            mainPanel.onSwitchAway();
            mainPanel.storeScrollPos();
            EchoScreen.this.setCurrentPage(this.page);
            mainPanel.refreshWidgets();
            scrollBar.setValue(mainPanel.fetchScrollPos());
        }
    }

    static abstract class PagePanel
    extends Panel {
        private final EchoScreen echoScreen;
        private final Page page;
        private double lastScrollPos = 0.0;

        public PagePanel(Panel parent, EchoScreen echoScreen, Page page) {
            super(parent);
            this.echoScreen = echoScreen;
            this.page = page;
        }

        public boolean shouldDraw() {
            return this.page == this.echoScreen.getCurrentPage();
        }

        public boolean isEnabled() {
            return this.page == this.echoScreen.getCurrentPage();
        }

        protected Optional<Echo> getEcho() {
            return Optional.ofNullable(this.echoScreen.echo);
        }

        protected final void vSpace(int space) {
            this.add((Widget)new VerticalSpaceWidget((Panel)this, space));
        }

        public void storeScrollPos() {
            this.lastScrollPos = this.echoScreen.scrollBar.getValue();
        }

        public double fetchScrollPos() {
            return this.lastScrollPos;
        }

        public void onSwitchAway() {
        }
    }

    class PurchaseButton
    extends SimpleTextButton {
        public PurchaseButton(Panel parent) {
            super(parent, (Component)Component.translatable((String)"ftbechoes.gui.place_order"), Icons.MONEY_BAG);
        }

        public void onClicked(MouseButton mouseButton) {
            this.playClickSound();
            PacketDistributor.sendToServer((CustomPacketPayload)new PlaceOrderMessage(ShoppingBasket.CLIENT_INSTANCE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        public boolean shouldAddMouseOverText() {
            return this.isMouseOver;
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            if (ShoppingBasket.CLIENT_INSTANCE.hasContents()) {
                list.add((Component)Component.translatable((String)"ftbechoes.gui.shopping_basket").withStyle(ChatFormatting.YELLOW));
                ShoppingBasket.CLIENT_INSTANCE.forEach((key, count) -> EchoManager.getClientInstance().getShopData((ShoppingKey)key).ifPresent(data -> {
                    ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
                    List<ItemStack> stacks = data.stacks();
                    for (int i = 0; i < stacks.size(); ++i) {
                        ItemStack stack = stacks.get(i);
                        lines.add(Component.literal((String)(i == 0 ? "\u2022 " : "  ")).append(count * stack.getCount() + " x ").append(stack.getHoverName()));
                    }
                    data.command().ifPresent(cmd -> cmd.description().forEach(d -> lines.add(Component.literal((String)"\u2022 ").append(d))));
                    if (!lines.isEmpty()) {
                        ((MutableComponent)lines.getLast()).append(": ").append(MiscUtil.formatCost(count * data.cost()));
                    }
                    lines.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                }));
                list.add((Component)Component.empty());
                list.add((Component)Component.translatable((String)"ftbechoes.tooltip.total_cost", (Object[])new Object[]{MiscUtil.formatCost(ShoppingBasket.CLIENT_INSTANCE.getTotalCost())}));
                if (ShoppingBasket.CLIENT_INSTANCE.getTotalCost() > FTBEchoes.currencyProvider().getTotalCurrency((Player)Minecraft.getInstance().player)) {
                    list.add((Component)Component.translatable((String)"ftbechoes.tooltip.too_expensive").withStyle(ChatFormatting.RED));
                }
            }
        }

        public WidgetType getWidgetType() {
            return this.isEnabled() ? super.getWidgetType() : WidgetType.DISABLED;
        }

        public boolean isEnabled() {
            return ShoppingBasket.CLIENT_INSTANCE.hasContents() && EchoScreen.this.getCurrentPage() == Page.SHOP && ShoppingBasket.CLIENT_INSTANCE.getTotalCost() <= FTBEchoes.currencyProvider().getTotalCurrency((Player)Minecraft.getInstance().player);
        }

        public boolean shouldDraw() {
            return EchoScreen.this.getCurrentPage() == Page.SHOP;
        }
    }
}

