/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.gui;

import dev.ftb.mods.ftbechoes.client.ClientProgress;
import dev.ftb.mods.ftbechoes.client.gui.EchoScreen;
import dev.ftb.mods.ftbechoes.client.gui.widget.ShopItemWidget;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoStage;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.shopping.ShopData;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.List;

public class ShopPanel
extends EchoScreen.PagePanel {
    public ShopPanel(Panel parent, EchoScreen echoScreen) {
        super(parent, echoScreen, EchoScreen.Page.SHOP);
    }

    public void addWidgets() {
        this.getEcho().ifPresent(echo -> {
            List<EchoStage> stages = echo.stages();
            TeamProgress teamProgress = ClientProgress.get();
            int currentStage = teamProgress.getCurrentStage(echo.id());
            for (int stageIdx = 0; stageIdx < stages.size(); ++stageIdx) {
                EchoStage stage = stages.get(stageIdx);
                for (ShopData data : stage.shopUnlocked()) {
                    if (currentStage > data.maxStage()) continue;
                    this.add((Widget)new ShopItemWidget(this, (Echo)echo, data, stage, stageIdx < currentStage, teamProgress));
                }
            }
        });
    }

    public void alignWidgets() {
        int paddedSize = 69;
        int perRow = (this.width - 5) / paddedSize;
        int curRow = 0;
        int curCol = 0;
        for (Widget w : this.widgets) {
            if (!(w instanceof ShopItemWidget)) continue;
            w.setPosAndSize(5 + curCol * paddedSize, 5 + curRow * paddedSize, 64, 64);
            if (++curCol < perRow) continue;
            ++curRow;
            curCol = 0;
        }
        this.setHeight(paddedSize * (curRow + 1));
    }
}

