/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgressManager;
import dev.ftb.mods.ftblibrary.FTBLibraryCommands;
import dev.ftb.mods.ftblibrary.net.EditNBTPacket;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public class NBTEditCommand {
    public static final String FTBECHOES_PROGRESS = "ftbechoes:progress";

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nbtedit").requires(ctx -> ctx.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> NBTEditCommand.doEdit((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))));
    }

    private static int doEdit(CommandContext<CommandSourceStack> ctx, ServerPlayer targetPlayer) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = src.getPlayerOrException();
        return TeamProgressManager.get(src.getServer()).getProgress(player).map(progress -> {
            CompoundTag info = (CompoundTag)Util.make((Object)new CompoundTag(), t -> {
                Component teamName = FTBTeamsAPI.api().getManager().getTeamForPlayer(targetPlayer).map(Team::getColoredName).orElse((Component)Component.literal((String)"<unknown>"));
                MutableComponent title = Component.literal((String)"Echo Progress for ").append(teamName);
                t.putString("title", Component.Serializer.toJson((Component)title, (HolderLookup.Provider)((CommandSourceStack)ctx.getSource()).registryAccess()));
                t.putString("type", FTBECHOES_PROGRESS);
                t.putUUID("id", targetPlayer.getUUID());
                t.put("text", (Tag)FTBLibraryCommands.InfoBuilder.create((CommandContext)ctx).add("Team ID", teamName).build());
            });
            return TeamProgress.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, progress).resultOrPartial(err -> src.sendFailure((Component)Component.literal((String)err).withStyle(ChatFormatting.RED))).map(tag -> {
                NetworkHelper.sendTo((ServerPlayer)player, (CustomPacketPayload)new EditNBTPacket(info, (CompoundTag)tag));
                return 1;
            }).orElse(0);
        }).orElse(0);
    }
}

