/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.triggerblock;

import dev.ftb.packcompanion.core.utils.ClientHelpers;
import dev.ftb.packcompanion.features.triggerblock.TriggerBlockController;
import dev.ftb.packcompanion.features.triggerblock.TriggerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TriggerBlock
extends Block
implements EntityBlock {
    public TriggerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        TriggerBlockController.INSTANCE.onPlayerIn(player, pos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Level l;
        if (level instanceof Level && (l = (Level)level).isClientSide()) {
            if (ClientHelpers.clientIsSurvival()) {
                return Shapes.empty();
            }
            return Shapes.block();
        }
        return Shapes.empty();
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TriggerBlockEntity(blockPos, blockState);
    }
}

