/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.triggerblock;

import dev.ftb.packcompanion.features.triggerblock.TriggerBlockFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TriggerBlockEntity
extends BlockEntity {
    private String name = "unknown";
    private String ignorePlayersWithTag = null;

    public TriggerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)TriggerBlockFeature.TRIGGER_BLOCK_ENTITY_TYPE.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("name", this.name);
        if (this.ignorePlayersWithTag != null && !this.ignorePlayersWithTag.isEmpty()) {
            tag.putString("ignoreTag", this.ignorePlayersWithTag);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("name")) {
            this.name = tag.getString("name");
        }
        if (tag.contains("ignoreTag")) {
            this.ignorePlayersWithTag = tag.getString("ignoreTag");
        }
    }

    public String name() {
        return this.name;
    }

    public String ignorePlayersWithTag() {
        return this.ignorePlayersWithTag;
    }
}

