/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.mixin.features.jerfix;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"jeresources.api.util.BiomeHelper"}, remap=false)
public class BiomeHelperMixin {
    @Inject(method={"getAllBiomes"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getAllBiomes(CallbackInfoReturnable<List<Biome>> cir) {
        Optional registry;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (registry = level.registryAccess().registry(Registries.BIOME)).isPresent()) {
            ArrayList biomes = new ArrayList();
            ((Registry)registry.get()).forEach(biomes::add);
            cir.setReturnValue(biomes);
        }
    }

    @Inject(method={"getBiome"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getBiome(ResourceKey<Biome> key, CallbackInfoReturnable<Biome> cir) {
        Biome biome;
        Optional registry;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (registry = level.registryAccess().registry(Registries.BIOME)).isPresent() && (biome = (Biome)((Registry)registry.get()).get(key)) != null) {
            cir.setReturnValue((Object)biome);
        }
    }

    @Inject(method={"getBiomes"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getBiomes(ResourceKey<Biome> category, CallbackInfoReturnable<List<Biome>> cir) {
        Optional registry;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (registry = level.registryAccess().registry(Registries.BIOME)).isPresent()) {
            ArrayList biomes = new ArrayList();
            ((Registry)registry.get()).asLookup().listElements().forEach(biomeEntry -> {
                if (biomeEntry.key().equals(category)) {
                    biomes.add((Biome)biomeEntry.value());
                }
            });
            cir.setReturnValue(biomes);
        }
    }
}

