/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.pmapi.menu;

import dev.ftb.mods.pmapi.api.PauseMenuApi;
import dev.ftb.mods.pmapi.api.menu.MenuLocation;
import dev.ftb.mods.pmapi.api.menu.PauseItemHolder;
import dev.ftb.mods.pmapi.api.menu.ScreenHolder;
import dev.ftb.mods.pmapi.api.menu.ScreenWidgetCollection;
import dev.ftb.mods.pmapi.menu.OriginalPauseScreenImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.apache.commons.lang3.tuple.Pair;

public class PauseMenuScreen
extends OriginalPauseScreenImpl {
    public static boolean DISABLE_CUSTOM_PAUSE = false;
    private final ScreenHolder holder = ScreenHolder.of(this);
    private final Set<ItemPlacement> placements = new HashSet<ItemPlacement>();

    @Override
    protected void init() {
        super.init();
        this.initPauseItems();
    }

    private void initPauseItems() {
        this.createPlacements();
        for (ItemPlacement placement : this.placements) {
            placement.initRenderables(this, this.holder);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        for (ItemPlacement placement : this.placements) {
            if (!placement.holder.provider().hasRender()) continue;
            placement.render(this.holder, guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void createPlacements() {
        int xOffset;
        ArrayList<PauseItemHolder> sortedItems;
        HashSet<PauseItemHolder> items;
        MenuLocation location;
        this.placements.clear();
        HashMap<MenuLocation, Pair> rowsToHeights = new HashMap<MenuLocation, Pair>();
        for (Map.Entry<MenuLocation, HashSet<PauseItemHolder>> locationToItems : PauseMenuApi.get().getPauseItems().entrySet()) {
            location = locationToItems.getKey();
            items = locationToItems.getValue();
            sortedItems = new ArrayList<PauseItemHolder>(items);
            sortedItems.sort(Comparator.comparingInt(e -> e.provider().sortingOrder()).reversed());
            xOffset = 0;
            int yOffest = 0;
            int widestWidth = 0;
            int highestHeight = 0;
            int targetMaxWidth = this.calculateMaxWidth(location);
            for (PauseItemHolder item : sortedItems) {
                if (item.provider().disabled()) continue;
                int itemWidth = item.provider().width();
                int itemHeight = item.provider().height();
                boolean hasOverflowed = false;
                if (xOffset + itemWidth > targetMaxWidth) {
                    xOffset = 0;
                    hasOverflowed = true;
                    yOffest += highestHeight + 4;
                    highestHeight = 0;
                }
                highestHeight = Math.max(highestHeight, itemHeight);
                widestWidth = Math.max(widestWidth, (xOffset += itemWidth + (hasOverflowed ? -4 : 4)) - 4);
            }
            rowsToHeights.put(location, Pair.of((Object)widestWidth, (Object)(yOffest += highestHeight)));
        }
        for (Map.Entry<MenuLocation, HashSet<PauseItemHolder>> locationToItems : PauseMenuApi.get().getPauseItems().entrySet()) {
            location = locationToItems.getKey();
            items = locationToItems.getValue();
            sortedItems = new ArrayList<PauseItemHolder>(items);
            sortedItems.sort(Comparator.comparingInt(e -> e.provider().sortingOrder()).reversed());
            xOffset = 0;
            int yOffset = 0;
            int maxWidth = this.calculateMaxWidth(location);
            int rowHighestHeight = 0;
            boolean isRightAligned = switch (location) {
                case MenuLocation.TOP_RIGHT, MenuLocation.BOTTOM_RIGHT, MenuLocation.MENU_LEFT -> true;
                default -> false;
            };
            boolean isCenterAligned = switch (location) {
                case MenuLocation.TOP_CENTER, MenuLocation.BOTTOM_CENTER -> true;
                default -> false;
            };
            boolean isBottomAligned = switch (location) {
                case MenuLocation.BOTTOM_RIGHT, MenuLocation.BOTTOM_CENTER, MenuLocation.BOTTOM_LEFT -> true;
                default -> false;
            };
            for (PauseItemHolder item : sortedItems) {
                if (item.provider().disabled()) continue;
                int itemWidth = item.provider().width();
                int itemHeight = item.provider().height();
                int[] position = this.calculatePosition(location);
                int renderX = position[0];
                int renderY = position[1];
                Pair rowDimensions = (Pair)rowsToHeights.get((Object)location);
                int rowHeight = (Integer)rowDimensions.getValue();
                int rowWidth = (Integer)rowDimensions.getKey();
                if (xOffset + itemWidth > maxWidth) {
                    xOffset = 0;
                    yOffset += rowHighestHeight + 4;
                    rowHighestHeight = 0;
                }
                if (isRightAligned) {
                    renderX -= rowWidth;
                } else if (isCenterAligned) {
                    renderX -= rowWidth / 2;
                }
                if (isBottomAligned) {
                    renderY -= rowHeight;
                }
                rowHighestHeight = Math.max(rowHighestHeight, itemHeight);
                int xPlacement = renderX + xOffset;
                int yPlacement = renderY + yOffset;
                this.placements.add(new ItemPlacement(item, xPlacement, yPlacement, item.provider().hasRender()));
                xOffset += itemWidth + 4;
            }
        }
    }

    private int[] calculatePosition(MenuLocation target) {
        int[] nArray;
        switch (target) {
            default: {
                throw new MatchException(null, null);
            }
            case TOP_LEFT: {
                int[] nArray2 = new int[2];
                nArray2[0] = 4;
                nArray = nArray2;
                nArray2[1] = 4;
                break;
            }
            case TOP_RIGHT: {
                int[] nArray3 = new int[2];
                nArray3[0] = this.width - 4;
                nArray = nArray3;
                nArray3[1] = 4;
                break;
            }
            case TOP_CENTER: {
                int[] nArray4 = new int[2];
                nArray4[0] = this.width / 2;
                nArray = nArray4;
                nArray4[1] = 4;
                break;
            }
            case BOTTOM_LEFT: {
                int[] nArray5 = new int[2];
                nArray5[0] = 4;
                nArray = nArray5;
                nArray5[1] = this.height - 4;
                break;
            }
            case BOTTOM_RIGHT: {
                int[] nArray6 = new int[2];
                nArray6[0] = this.width - 4;
                nArray = nArray6;
                nArray6[1] = this.height - 4;
                break;
            }
            case BOTTOM_CENTER: {
                int[] nArray7 = new int[2];
                nArray7[0] = this.width / 2;
                nArray = nArray7;
                nArray7[1] = this.height - 4;
                break;
            }
            case MENU_LEFT: {
                int[] nArray8 = new int[2];
                nArray8[0] = this.width / 2 - 102 - 4;
                nArray = nArray8;
                nArray8[1] = this.height / 4 + 9;
                break;
            }
            case MENU_RIGHT: {
                int[] nArray9 = new int[2];
                nArray9[0] = this.width / 2 + 102 + 4;
                nArray = nArray9;
                nArray9[1] = this.height / 4 + 9;
            }
        }
        return nArray;
    }

    private int calculateMaxWidth(MenuLocation target) {
        return switch (target) {
            default -> throw new MatchException(null, null);
            case MenuLocation.TOP_RIGHT, MenuLocation.BOTTOM_RIGHT, MenuLocation.TOP_CENTER, MenuLocation.BOTTOM_CENTER, MenuLocation.BOTTOM_LEFT, MenuLocation.TOP_LEFT -> this.width / 3;
            case MenuLocation.MENU_LEFT, MenuLocation.MENU_RIGHT -> 80;
        };
    }

    private record ItemPlacement(PauseItemHolder holder, int x, int y, boolean hasRender) {
        private void initRenderables(Screen screen, ScreenHolder screenHolder) {
            ScreenWidgetCollection elements = this.holder.provider().init(this.holder.location(), screenHolder, this.x, this.y);
            if (elements == null) {
                return;
            }
            elements.commitToScreen(screen);
        }

        private void render(ScreenHolder screenHolder, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.holder.provider().render(this.holder.location(), screenHolder, graphics, this.x, this.y, mouseX, mouseY, partialTick);
        }
    }
}

