/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.api.requirements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.ftb.mods.promoter.api.PromoData;
import dev.ftb.mods.promoter.api.requirements.MinecraftRequirement;
import dev.ftb.mods.promoter.api.requirements.ModRequirement;
import java.lang.reflect.Type;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Requirement {
    public String type;

    public abstract boolean test(PromoData var1);

    public static class RequirementDeserializer
    implements JsonDeserializer<Requirement> {
        private static final Logger LOGGER = LogManager.getLogger(RequirementDeserializer.class);

        public Requirement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("Requirement must be an object");
            }
            if (!json.getAsJsonObject().has("type")) {
                throw new JsonParseException("Requirement must have a type");
            }
            String type = json.getAsJsonObject().get("type").getAsString();
            try {
                switch (type) {
                    case "minecraft_version": {
                        return MinecraftRequirement.deserialize(type, json, typeOfT, context);
                    }
                    case "mod_loaded": {
                        return ModRequirement.deserialize(type, json, typeOfT, context);
                    }
                }
                LOGGER.warn("Unsupported requirement type: {}", (Object)type);
                return null;
            }
            catch (JsonParseException e) {
                LOGGER.error("Failed to parse requirement of type {}", (Object)type, (Object)e);
                return null;
            }
        }
    }
}

