/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FluidTask
extends Task {
    public static final ResourceLocation TANK_TEXTURE = FTBQuestsAPI.rl("textures/tasks/tank.png");
    private static final FluidStack WATER = FluidStack.create((Fluid)Fluids.WATER, (long)FluidStack.bucketAmount());
    private FluidStack fluidStack = FluidStack.create((Fluid)Fluids.WATER, (long)FluidStack.bucketAmount());

    public FluidTask(long id, Quest quest) {
        super(id, quest);
    }

    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    public FluidTask setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    public DataComponentMap getFluidDataComponents() {
        return this.fluidStack.getComponents();
    }

    public DataComponentPatch getFluidDataComponentPatch() {
        return this.fluidStack.getComponents().asPatch();
    }

    @Override
    public TaskType getType() {
        return TaskTypes.FLUID;
    }

    @Override
    public long getMaxProgress() {
        return this.fluidStack.getAmount();
    }

    @Override
    public String formatMaxProgress() {
        return FluidTask.getVolumeString(this.fluidStack.getAmount());
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return FluidTask.getVolumeString((int)Math.min(Integer.MAX_VALUE, progress));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.put("fluid", this.fluidStack.write(provider, (Tag)new CompoundTag()));
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        ResourceLocation id;
        super.readData(nbt, provider);
        this.fluidStack = nbt.contains("fluid", 8) ? ((id = ResourceLocation.tryParse((String)nbt.getString("fluid"))) == null ? FluidStack.create((Fluid)Fluids.WATER, (long)1000L) : FluidStack.create((Fluid)((Fluid)BuiltInRegistries.FLUID.get(id)), (long)nbt.getLong("amount"))) : FluidStack.read((HolderLookup.Provider)provider, (Tag)nbt.getCompound("fluid")).orElse(FluidStack.empty());
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        this.fluidStack.write(buffer);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.fluidStack = FluidStack.read((RegistryFriendlyByteBuf)buffer);
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= FluidStack.bucketAmount()) {
            if (a % FluidStack.bucketAmount() != 0L) {
                builder.append(StringUtils.formatDouble((double)((double)a / (double)FluidStack.bucketAmount())));
            } else {
                builder.append(a / FluidStack.bucketAmount());
            }
            builder.append(" B");
        } else {
            builder.append(a).append(" mB");
        }
        return builder.toString();
    }

    public MutableComponent getAltTitle() {
        return Component.literal((String)(FluidTask.getVolumeString(this.fluidStack.getAmount()) + " of ")).append(this.fluidStack.getName());
    }

    @Override
    public Icon getAltIcon() {
        return Icon.getIcon((ResourceLocation)ClientUtils.getStillTexture((FluidStack)this.fluidStack)).withTint(Color4I.rgb((int)ClientUtils.getFluidColor((FluidStack)this.fluidStack)));
    }

    @Override
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addFluidStack("fluid", this.fluidStack, v -> {
            this.fluidStack = v;
        }, WATER, false);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @Nullable
    public Optional<PositionedIngredient> getIngredient(Widget widget) {
        return PositionedIngredient.of((Object)this.fluidStack, (Widget)widget);
    }
}

