/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.client;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientUtil {
    public static <T> Optional<T> getBlockEntityAt(BlockPos pos, Class<T> cls) {
        BlockEntity te;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && pos != null && level.isLoaded(pos) && (te = level.getBlockEntity(pos)) != null && cls.isAssignableFrom(te.getClass())) {
            return Optional.of(te);
        }
        return Optional.empty();
    }

    public static void maybeAddBlockTooltip(ItemStack stack, List<Component> tooltips) {
        String tooltipKey = stack.getDescriptionId() + ".tooltip";
        if (I18n.exists((String)tooltipKey)) {
            tooltips.add((Component)Component.translatable((String)tooltipKey).withStyle(ChatFormatting.GRAY));
        }
    }
}

