/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeMultiCache<R extends Recipe<?>> {
    private static final int MAX_CACHE_SIZE = 1024;
    private final Int2ObjectLinkedOpenHashMap<List<RecipeHolder<R>>> recipeCache = new Int2ObjectLinkedOpenHashMap(1024, 0.25f);

    public List<RecipeHolder<R>> getCachedRecipes(Supplier<List<RecipeHolder<R>>> recipeFinder, IntSupplier hashCodeGenerator) {
        int key = hashCodeGenerator.getAsInt();
        if (this.recipeCache.containsKey(key)) {
            return (List)this.recipeCache.getAndMoveToFirst(key);
        }
        List<RecipeHolder<R>> newRecipes = recipeFinder.get();
        while (this.recipeCache.size() >= 1024) {
            this.recipeCache.removeLast();
        }
        this.recipeCache.put(key, newRecipes);
        return newRecipes;
    }

    void clear() {
        this.recipeCache.clear();
    }
}

