/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.crafting.BaseRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import dev.ftb.mods.ftbstuffnthings.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class DripperRecipe
extends BaseRecipe<DripperRecipe> {
    private final String inputStateStr;
    private final BlockPredicateArgument.Result inputPredicate;
    private final String outputString;
    private final BlockState outputState;
    private final FluidStack fluid;
    private final double chance;
    private final boolean consumeFluidOnFail;

    public DripperRecipe(String inputStateStr, String outputStateStr, FluidStack fluid, double chance, boolean consumeFluidOnFail) {
        super(RecipesRegistry.DRIP_SERIALIZER, RecipesRegistry.DRIP_TYPE);
        this.inputStateStr = inputStateStr;
        this.outputString = outputStateStr;
        this.fluid = fluid;
        this.chance = chance;
        this.consumeFluidOnFail = consumeFluidOnFail;
        try {
            this.inputPredicate = BlockPredicateArgument.parse((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(inputStateStr));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        try {
            BlockStateParser.BlockResult blockResult = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(outputStateStr), (boolean)false);
            this.outputState = blockResult.blockState();
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public String getInputStateStr() {
        return this.inputStateStr;
    }

    public String getOutputStateStr() {
        return this.outputString;
    }

    private Set<Block> getInputBlocks() {
        BlockPredicateArgument.Result result = this.inputPredicate;
        if (result instanceof BlockPredicateArgument.BlockPredicate) {
            BlockPredicateArgument.BlockPredicate b = (BlockPredicateArgument.BlockPredicate)result;
            return Set.of(b.state.getBlock());
        }
        result = this.inputPredicate;
        if (result instanceof BlockPredicateArgument.TagPredicate) {
            BlockPredicateArgument.TagPredicate t = (BlockPredicateArgument.TagPredicate)result;
            return t.tag.stream().map(Holder::value).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public List<Either<ItemStack, Fluid>> getInputsForDisplay() {
        Set<Block> blocks = this.getInputBlocks();
        ArrayList<Either<ItemStack, Fluid>> res = new ArrayList<Either<ItemStack, Fluid>>();
        for (Block b : blocks) {
            if (b instanceof LiquidBlock) {
                LiquidBlock l = (LiquidBlock)b;
                if (l.fluid == Fluids.EMPTY) continue;
                res.add((Either<ItemStack, Fluid>)Either.right((Object)l.fluid));
                continue;
            }
            ItemStack s = b.asItem().getDefaultInstance();
            if (s.isEmpty()) continue;
            res.add((Either<ItemStack, Fluid>)Either.left((Object)s));
        }
        return res;
    }

    public Either<ItemStack, Fluid> getOutputItemOrFluid() {
        Either either;
        Block b = this.outputState.getBlock();
        if (b instanceof LiquidBlock) {
            LiquidBlock l = (LiquidBlock)b;
            either = Either.right((Object)l.fluid);
        } else {
            either = Either.left((Object)b.asItem().getDefaultInstance());
        }
        return either;
    }

    public BlockState getOutputState() {
        return this.outputState;
    }

    public boolean consumeFluidOnFail() {
        return this.consumeFluidOnFail;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public double getChance() {
        return this.chance;
    }

    public boolean testInput(FluidStack fluidInDripper, Level level, BlockPos pos) {
        return FluidStack.isSameFluidSameComponents((FluidStack)fluidInDripper, (FluidStack)this.fluid) && this.inputPredicate.test((Object)new BlockInWorld((LevelReader)level, pos, false));
    }

    public static class Serializer<T extends DripperRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("input").forGetter(DripperRecipe::getInputStateStr), (App)Codec.STRING.fieldOf("output").forGetter(DripperRecipe::getOutputStateStr), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(DripperRecipe::getFluid), (App)Codec.DOUBLE.validate(MiscUtil::validateChanceRange).optionalFieldOf("chance", (Object)1.0).forGetter(DripperRecipe::getChance), (App)Codec.BOOL.optionalFieldOf("consume_fluid_on_fail", (Object)false).forGetter(DripperRecipe::consumeFluidOnFail)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, DripperRecipe::getInputStateStr, (StreamCodec)ByteBufCodecs.STRING_UTF8, DripperRecipe::getOutputStateStr, (StreamCodec)FluidStack.STREAM_CODEC, DripperRecipe::getFluid, (StreamCodec)ByteBufCodecs.DOUBLE, DripperRecipe::getChance, (StreamCodec)ByteBufCodecs.BOOL, DripperRecipe::consumeFluidOnFail, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends DripperRecipe> {
        public T create(String var1, String var2, FluidStack var3, double var4, boolean var6);
    }
}

