/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.pump.PumpBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.strainer.WaterStrainerBlock;
import dev.ftb.mods.ftbstuffnthings.client.model.TubeModel;
import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.Temperature;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BlockStatesGenerators
extends BlockStateProvider {
    private static final List<DirRotation> HORIZONTALS = (List)Util.make(new ArrayList(), l -> {
        l.add(new DirRotation(Direction.NORTH, 0));
        l.add(new DirRotation(Direction.EAST, 90));
        l.add(new DirRotation(Direction.SOUTH, 180));
        l.add(new DirRotation(Direction.WEST, 270));
    });

    public BlockStatesGenerators(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "ftbstuff", exFileHelper);
    }

    protected void registerStatesAndModels() {
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        int[] dirsRot = new int[]{0, 180, 270, 90};
        for (DeferredBlock<SluiceBlock> block2 : BlocksRegistry.ALL_SLUICES) {
            String key = block2.getKey().location().getPath();
            MultiPartBlockStateBuilder multiPartBlockStateBuilder = this.getMultipartBuilder((Block)block2.get());
            for (int d = 0; d < 4; ++d) {
                ((MultiPartBlockStateBuilder.PartBuilder)multiPartBlockStateBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + key + "_body"))).rotationY(dirsRot[d]).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]}).condition(SluiceBlock.PART, (Comparable[])new SluiceBlock.Part[]{SluiceBlock.Part.MAIN});
                ((MultiPartBlockStateBuilder.PartBuilder)multiPartBlockStateBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + key + "_front"))).rotationY(dirsRot[d]).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]}).condition(SluiceBlock.PART, (Comparable[])new SluiceBlock.Part[]{SluiceBlock.Part.FUNNEL});
                for (MeshType meshType : MeshType.NON_EMPTY_VALUES) {
                    ((MultiPartBlockStateBuilder.PartBuilder)multiPartBlockStateBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + meshType.getSerializedName() + "_mesh"))).rotationY(dirsRot[d]).addModel()).condition(SluiceBlock.MESH, (Comparable[])new MeshType[]{meshType}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]}).condition(SluiceBlock.PART, (Comparable[])new SluiceBlock.Part[]{SluiceBlock.Part.MAIN});
                }
            }
        }
        int[] dirsRot2 = new int[]{90, 270, 0, 180};
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)BlocksRegistry.PUMP.get());
        for (int d = 0; d < 4; ++d) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/pump_off"))).rotationY(dirsRot2[d]).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/pump_on"))).rotationY(dirsRot2[d]).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/pump_20"))).rotationY(dirsRot2[d]).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]}).condition(PumpBlock.PROGRESS, (Comparable[])new PumpBlock.Progress[]{PumpBlock.Progress.TWENTY});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/pump_40"))).rotationY(dirsRot2[d]).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]}).condition(PumpBlock.PROGRESS, (Comparable[])new PumpBlock.Progress[]{PumpBlock.Progress.FORTY});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/pump_60"))).rotationY(dirsRot2[d]).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]}).condition(PumpBlock.PROGRESS, (Comparable[])new PumpBlock.Progress[]{PumpBlock.Progress.SIXTY});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/pump_80"))).rotationY(dirsRot2[d]).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]}).condition(PumpBlock.PROGRESS, (Comparable[])new PumpBlock.Progress[]{PumpBlock.Progress.EIGHTY});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/pump_100"))).rotationY(dirsRot2[d]).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{dirs[d]}).condition(PumpBlock.PROGRESS, (Comparable[])new PumpBlock.Progress[]{PumpBlock.Progress.HUNDRED});
        }
        for (DeferredBlock<AutoHammerBlock> deferredBlock : List.of(BlocksRegistry.IRON_AUTO_HAMMER, BlocksRegistry.GOLD_AUTO_HAMMER, BlocksRegistry.DIAMOND_AUTO_HAMMER, BlocksRegistry.NETHERITE_AUTO_HAMMER)) {
            MultiPartBlockStateBuilder b = this.getMultipartBuilder((Block)deferredBlock.get());
            String path = deferredBlock.getId().getPath();
            for (DirRotation d : HORIZONTALS) {
                ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + path))).rotationY(d.rotation).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{d.direction});
                ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + path + "_active"))).rotationY(d.rotation).addModel()).condition((Property)AbstractMachineBlock.ACTIVE, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{d.direction});
            }
        }
        Stream.concat(BlocksRegistry.COBBLEGENS.stream(), BlocksRegistry.BASALTGENS.stream()).forEach(block -> {
            MultiPartBlockStateBuilder b = this.getMultipartBuilder((Block)block.get());
            String path = block.getId().getPath();
            for (DirRotation d : HORIZONTALS) {
                ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + path))).rotationY(d.rotation).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{d.direction});
            }
        });
        for (DeferredBlock deferredBlock : List.of(BlocksRegistry.FUSING_MACHINE, BlocksRegistry.SUPER_COOLER)) {
            ModelFile model = this.machineModel((DeferredBlock<? extends Block>)deferredBlock, false);
            ModelFile activeModel = this.machineModel((DeferredBlock<? extends Block>)deferredBlock, true);
            VariantBlockStateBuilder.PartialBlockstate partialBlockstate = this.getVariantBuilder((Block)deferredBlock.get()).partialState();
            for (DirRotation d : HORIZONTALS) {
                partialBlockstate.with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)d.direction).with((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, d.rotation, false)});
                partialBlockstate.with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)d.direction).with((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(activeModel, 0, d.rotation, false)});
            }
            this.simpleBlockItem((Block)deferredBlock.get(), model);
        }
        TubeLoaderBuilder tlb = (TubeLoaderBuilder)((BlockModelBuilder)this.models().getBuilder("block/tube")).customLoader(TubeLoaderBuilder::new);
        this.simpleBlock((Block)BlocksRegistry.TUBE.get(), (ModelFile)tlb.end());
        this.models().withExistingParent("block/tube_inv", this.modLoc("block/tube_base"));
        ModelBuilder modelBuilder = this.models().withExistingParent("block/dripper", this.modLoc("block/dripper_base"));
        this.simpleBlock((Block)BlocksRegistry.DRIPPER.get(), (ModelFile)modelBuilder);
        this.simpleBlock((Block)BlocksRegistry.WOODEN_BASIN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/wooden_basin")));
        ModelBuilder jarModel = this.models().withExistingParent("block/jar", this.modLoc("block/jar_base"));
        this.simpleBlock((Block)BlocksRegistry.JAR.get(), (ModelFile)jarModel);
        this.getVariantBuilder((Block)BlocksRegistry.TEMPERED_JAR.get()).forAllStates(state -> {
            Temperature temp = (Temperature)((Object)((Object)((Object)state.getValue(TemperedJarBlock.TEMPERATURE))));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("tempered_jar_" + temp.getSerializedName(), this.modLoc("block/jar_base"))).texture("cover", this.modLoc("block/cast_iron_jar_cover"))).texture("glass_side", this.modLoc("block/jar_glass_side_" + temp.getSerializedName()))).texture("glass_top", this.modLoc("block/jar_glass_tempered_top"))).texture("glass_bottom", this.modLoc("block/jar_glass_bottom_" + temp.getSerializedName()))).build();
        });
        this.simpleBlock((Block)BlocksRegistry.JAR_AUTOMATER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/auto_processing_block")));
        BlocksRegistry.BARRELS.forEach(block -> {
            String name = block.getId().getPath();
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + name));
            this.simpleBlock((Block)block.get(), (ModelFile)model);
        });
        this.simpleBlock((Block)BlocksRegistry.CRATE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/crate")));
        this.simpleBlock((Block)BlocksRegistry.PULSATING_CRATE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/pulsating_crate")));
        ModelFile.ExistingModelFile smallCrateModel = this.models().getExistingFile(this.modLoc("block/small_crate"));
        this.getVariantBuilder((Block)BlocksRegistry.SMALL_CRATE.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)smallCrateModel).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build(), new Property[]{BlockStateProperties.WATERLOGGED});
        BlocksRegistry.waterStrainers().forEach(this::waterStrainer);
        BlocksRegistry.allCompressedBlocks().forEach(db -> {
            Object patt0$temp = db.get();
            if (patt0$temp instanceof RotatedPillarBlock) {
                RotatedPillarBlock pillar = (RotatedPillarBlock)patt0$temp;
                ResourceLocation side = FTBStuffNThings.id("block/" + db.getId().getPath() + "_side");
                ResourceLocation end = FTBStuffNThings.id("block/" + db.getId().getPath() + "_top");
                this.axisBlock(pillar, side, end);
            } else {
                this.simpleBlock((Block)db.get());
            }
        });
        this.simpleBlock((Block)BlocksRegistry.BLUE_MAGMA_BLOCK.get());
        this.simpleBlock((Block)BlocksRegistry.CREATIVE_HOT_TEMPERATURE_SOURCE.get());
        this.simpleBlock((Block)BlocksRegistry.CREATIVE_SUPERHEATED_TEMPERATURE_SOURCE.get());
        this.simpleBlock((Block)BlocksRegistry.CREATIVE_CHILLED_TEMPERATURE_SOURCE.get());
        this.simpleBlock((Block)BlocksRegistry.CAST_IRON_BLOCK.get());
        this.simpleBlock((Block)BlocksRegistry.DUST_BLOCK.get());
        this.simpleBlock((Block)BlocksRegistry.CRUSHED_BASALT.get());
        this.simpleBlock((Block)BlocksRegistry.CRUSHED_ENDSTONE.get());
        this.simpleBlock((Block)BlocksRegistry.CRUSHED_NETHERRACK.get());
    }

    private ModelFile machineModel(DeferredBlock<? extends Block> block, boolean active) {
        String name = block.getId().getPath();
        String suffix = active ? "_active" : "";
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + suffix, "block/orientable")).texture("top", this.modLoc("block/" + name + "_top" + suffix))).texture("side", this.modLoc("block/generic_machine_side"))).texture("front", this.modLoc("block/" + name + "_front" + suffix));
    }

    private void waterStrainer(Supplier<WaterStrainerBlock> blockSupplier) {
        WoodType type = blockSupplier.get().getWoodType();
        this.simpleBlock(blockSupplier.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(type.name() + "_water_strainer", this.modLoc("block/water_strainer_base"))).texture("0", "block/water_strainer/water_strainer_" + type.name())).texture("particle", "block/water_strainer/water_strainer_" + type.name()));
    }

    private record DirRotation(Direction direction, int rotation) {
    }

    private static class TubeLoaderBuilder
    extends CustomLoaderBuilder<BlockModelBuilder> {
        public TubeLoaderBuilder(BlockModelBuilder parent, ExistingFileHelper existingFileHelper) {
            super(TubeModel.Loader.ID, (ModelBuilder)parent, existingFileHelper, false);
        }
    }
}

