/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarMenu;
import dev.ftb.mods.ftbstuffnthings.client.screens.TemperedJarScreen;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.JarRecipe;
import dev.ftb.mods.ftbstuffnthings.integration.jei.BaseStuffCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.FTBStuffIngredientTypes;
import dev.ftb.mods.ftbstuffnthings.integration.jei.FluidAmountDrawable;
import dev.ftb.mods.ftbstuffnthings.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.TemperatureAndEfficiency;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TemperedJarCategory
extends BaseStuffCategory<JarRecipe> {
    protected TemperedJarCategory() {
        super(RecipeTypes.TEMPERED_JAR, (Component)Component.translatable((String)((TemperedJarBlock)BlocksRegistry.TEMPERED_JAR.get()).getDescriptionId()), (IDrawable)TemperedJarCategory.guiHelper().drawableBuilder(TemperedJarCategory.bgTexture("jei_tempered_jar.png"), 0, 0, 150, 18).setTextureSize(256, 32).build(), TemperedJarCategory.guiHelper().createDrawableItemStack(new ItemStack((ItemLike)ItemsRegistry.TEMPERED_JAR.get())));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JarRecipe recipe, IFocusGroup focuses) {
        int i;
        int nFluidsIn = recipe.getInputFluids().size();
        int nItemsIn = recipe.getInputItems().size();
        int nFluidsOut = recipe.getOutputFluids().size();
        int nItemsOut = recipe.getOutputItems().size();
        for (i = 0; i < nFluidsIn; ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1 + i * 20, 1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.getInputFluids().get(i).getFluids()))).setOverlay((IDrawable)new FluidAmountDrawable(recipe.getInputFluids().get(i).amount()), 0, 0);
        }
        for (i = 0; i < nItemsIn; ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + (i + nFluidsIn) * 20, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getInputItems().get(i).getItems()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 67, 1).addIngredient(FTBStuffIngredientTypes.TEMPERATURE, (Object)recipe.getTemperature())).addRichTooltipCallback((recipeSlotView, tooltip) -> {
            String time = String.format("%.1f", Float.valueOf((float)recipe.getTime() / 20.0f));
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.processing_time", (Object[])new Object[]{time}));
        });
        for (i = 0; i < nFluidsOut; ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 93 + i * 20, 1).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluids().get(i))).setOverlay((IDrawable)new FluidAmountDrawable(recipe.getOutputFluids().get(i).getAmount()), 0, 0);
        }
        for (i = 0; i < nItemsOut; ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 93 + (i + nFluidsOut) * 20, 1).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getOutputItems().get(i));
        }
    }

    public static List<JarRecipe> sortRecipes(List<JarRecipe> jarRecipes) {
        return jarRecipes.stream().sorted().toList();
    }

    private record TemperatureClickableGuiArea(TemperedJarScreen jarScreen) implements IGuiClickableArea
    {
        public Rect2i getArea() {
            return TemperedJarScreen.TEMPERATURE_AREA;
        }

        public void onClick(IFocusFactory focusFactory, IRecipesGui recipesGui) {
            recipesGui.showTypes(List.of(RecipeTypes.TEMPERATURE_SOURCE));
        }

        public void getTooltip(ITooltipBuilder tooltip) {
            TemperatureAndEfficiency tempEff = ((TemperedJarMenu)this.jarScreen.getMenu()).getJar().getTemperature();
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.temperature", (Object[])new Object[]{tempEff.temperature().getName()}));
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.efficiency", (Object[])new Object[]{tempEff.formatEfficiency()}));
            tooltip.add((FormattedText)Component.empty());
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.temperature_source.click"));
        }
    }

    static enum ContainerHandler implements IGuiContainerHandler<TemperedJarScreen>
    {
        INSTANCE;


        public Collection<IGuiClickableArea> getGuiClickableAreas(TemperedJarScreen containerScreen, double guiMouseX, double guiMouseY) {
            return List.of(IGuiClickableArea.createBasic((int)TemperedJarScreen.JEI_AREA.getX(), (int)TemperedJarScreen.JEI_AREA.getY(), (int)TemperedJarScreen.JEI_AREA.getWidth(), (int)TemperedJarScreen.JEI_AREA.getHeight(), (RecipeType[])new RecipeType[]{RecipeTypes.TEMPERED_JAR}), new TemperatureClickableGuiArea(containerScreen));
        }
    }
}

